## Schema Snapshots

Schema snapshots (formerly called `Offline` schemas) are schemas that are not connected to their actual data
source (e.g., DB). Instead, they're using a snapshot of the required data. They can for example be used to work
in a disconnected mode when the DBs are not available. Snapshots can be thought of as `backups` of the schemas
but differ a bit from them. Please refer to the [backup](schema_backup.md) page for more details.

These data snapshots are saved within the icCube application directory `~/offline`.
See the `icCube.xml` configuration for more details about its settings.

### Create a Data Snapshot

To create such a data snapshot you'll have to load the schema using its actual data source
and request icCube to create the snapshot. For that purpose, in the monitoring tab `To Load`
you'll find an action to load schema using extra parameters; select `Load & Create Snapshot`:

![create snapshot](img/offline_write_large.png)

### Load a Data Snapshot

To use a certain data snapshot, find the snapshot you would like to restore under `Admin / Snapshots`.
Select on the corresponding snapshot of the desired creation date, and find the `RESTORE` button on
the top right menu:

![load snapshot](img/offline_load_large.png)

Once loaded, you can check that the schema is using offline data, by looking at the Admin tab `Loaded`.
There the schema information is showing the actual date of the data snapshot being used:

![loaded snapshot](img/offline_loaded_large.png)

Next chapter: [Monitoring Counters](monitoring_counters.md) details several counters for monitoring the icCube server.

_
