## Schema Alerts

An alert is an MDX boolean expression that can be scheduled to be evaluated at certain times or when
schema data has been updated. If the expression evaluates to true then an `ALERT` notification is triggered.
Depending on the actual configuration of the notification service, this notification can generate an eMail.

### Access Rights

![role alerts](img/role_alerts_large.png)

To access the alert feature, you must log into icCube using a role that grants alerts usage.

### Alert Scheduler

![scheduler alerts](img/scheduler_alerts_large.png)

Alerts are created using the `Admin / Alerts` application. Their definitions are persisted within
the `icCubeScheduler-alerts.icc-scheduler` file. Scheduling an alert is based on the same triggers used
load schema scheduler.

### Alert Triggers

Alert triggers are similar to the ones used in the loading schema scheduler. Please refer to this
[page](schema_scheduler.md#triggers) for more information about the available triggers.

### eMail (Notification Service)

Internally, when an alert evaluation is triggered and its result is true, an `ALERT` notification is created
and sent to the [notification service](../configuring_iccube/iccube_notification_xml.md). Then,
depending on its configuration, an eMail can be generated. Configuration of the eMail is done within the
alert definition. Even if we strongly advise referencing reports instead of printing them, the generated
eMail can contain a report PDF.

### Fallback eMail

Note that the alert definition allows for configuring an alternate eMail that is sent in case of error
during the processing of the alert (e.g., MDX evaluation error, PDF generation timeout, etc...).

### PDF Generation

Using alerts, users can export their dashboards into PDF documents. This is useful for sharing static
versions of reports with stakeholders who may not have access to the icCube platform.

### Widget Data Export

On top of dashboard PDF generation, an alert can export the underlying of a widget contained in a dashboards.
Available formats are : Excel (i.e., XLSX file) and CSV. In the `Widget` tab, you can specify the ID of the widget. 
When this ID is specified, the alert will not generate a PDF of the dashboard anymore :

![scheduler alerts _widget](img/scheduler_alerts_widget_large.png)


Next chapter: [Schemas Backups](schema_backup.md) is explaining how to back up schemas.

_