## Access Rights / Permissions

In icCube, access rights allow to authorize and/or deny access to several resources : application features,
schemas/cubes, dimensions, members, cells (or facts), etc... They are defined by roles. Users can then be
attached to one or more roles. Upon login, users can decide to use their default role (the first in their
list of roles) or specify a role using the syntax `username/rolename` in the login window.

Roles are configured using the monitoring/roles application in the WEB user interface.

### Applications

It is possible to authorize and deny access to several applications (or features) of WEB interface.
The same way, access to both the XMLA and Google visualization network interfaces can be restricted.

![roles applications](img/roles_applications_large.png)

Note that granting access to the Builder will provide **access to all schema definitions**. For information on the schema's **data** access, refer to the Schemas Permissions below.

### Schemas

Schemas permissions allows for granting access to data from the schema level down to a (cube) cell level.
Refer to this [page](schema_permissions.md) for a detailed description of the schemas' permissions.

### Dashboards

Dashboards permissions allows for disabling features in the Dashboards application (editor).
Refer to this [page](dashboards_permissions.md) for a detailed description.

### Docs

Docs permissions allows for overriding the files and folders permissions as defined in the Docs repository.
Refer to this [page](docs_permissions.md) for a detailed description.

### File : icCubeRoles.icc-users

Roles definitions are stored within the file `icCubeRoles.icc-roles` that is located within the
`roles` directory as defined in the file [icCube.xml](../configuring_iccube/iccube_xml.md)
and available in the [Admin](../configuring_iccube/accessing_configuration.md) WEB interface.

Next chapter : [Schema Permissions](schema_permissions.md).

_
