## Schemas Properties

This page describes various global configuration properties of a schema.

### Members Upper/Lowercase Strategy

Since icCube 8.5.

This property defines the strategy for handling name or key (defined as string) collisions; that is, when two strings 
differ only in upper or lower case. 

![collisions](img/prop_case_collisions.png)

The possible value are :

    Use First String : (Default value) In case of upper/lower case collision use the first string (name or key).
    Passthrough      : Does nothing.

The value of this property can be **overridden in any dimension** using the dimension advanced properties
section.

`Use First String` is used as default value for backward compatibility reason but, we advise using
`Passthrough` if you want to ensure your model has no collision and/or `SPAIN` is not the same as 
`spain` when used as key.

**Key Value**

When using `Use First String`, the generated MDX key is always in upper case. The MDX lookup is 
case-insensitive.

**Name Value**

When using `Use First String`, the generated MDX name (and its default caption) corresponds to the first read value
that might change from load to load (asynchronous load). The MDX lookup is case-insensitive as usual.

### Migrating from Earlier Versions

The value of the property will be `Use First String` and your model should still load. Note that if you have
persisted some MDX unique names based on keys (for example in tests), they might be in upper-case right now. 
Review carefully as well your security definition (schema permissions) and your dashboards constants.

In any case do not hesitate to [contact us](https://www.iccube.com/contact-us/).     

Next chapter: [Data Sources](datasources.md) describes in more detail the available data sources in icCube.

_
