## Facts No Aggregation

In all our previous examples, data linked with members was automatically aggregated to parent and ancestor members.
For example, adding a value for `[2000 Jan]` was adding the value for the year `[2000]`, its parent/ancestor. There
are some special cases where this behavior is not expected. This might be because the data for intermediate nodes
is calculated by another system, for example risk calculations that are complex and not linear, or that the
hierarchical structure is not for data aggregation but for visual purpose.

Let's go to our sales schema, the `[Employee]` dimension might be an example of the latest case. We want to be able
to represent the full employees in a hierarchical representation however we do not want to aggregate measures. Sales
figures should only match the numbers of the employees and should not include its descendants numbers (people
reporting to him).

In icCube, it's possible to define a hierarchy that is not going to aggregate values to the parent and ancestors.
This can be triggered in the dimension use case by setting the attribute `Fact Aggr. Type` to `Members Only` to
a hierarchy :

![no aggregation](img/walk-facts_noaggr_hier_large.png)

Once deployed, we can check the results running a query on `[Employees II]` dimension and see how data is not
aggregated on parents and ancestors:

![no aggregation result](img/walk-facts_noaggr_res_large.png)

### Download

The schema of all fact examples is available for download [here](data/Walkthrough_Facts.zip).

Next chapter: [Facts Dimension/Facts Consistency](facts_dim_facts_consistency.md).

_
