## Facts: Many-to-Many (Bridges)

Bridges tables allows for creating many-2-many structures. A bridge table is an intermediate table that defines
a many-to-many relation between a fact row and a dimension table.

### Walkthrough

We need to create a new schema that will have three tables, `Dim`, `Fact` and `Bridge` :

The `Dim` tTable (the one defining our dimension) :

```
dim_member_id, name
1,             I'm One
2,             I'm Two
```

The `Fact` table (the one defining the facts) :

```
ft_id, value
1,     1
2,     2
```

The `Bridge` table (the one defining te many-to-many between the `Dim` table and the `Fact` table) :

```
br_member_id, br_fid
1,            1
2,            1
2,            2
```

As you can see the bridge table allows for binding the second row of the fact table to both dimension members
`I'm One` and `I'm Two`. After creating our dimension, defining the many-to-many relation in the measure group
is straightforward. Select `Last Level (default)` as the link method and click on the link as shown on the
image below :

![select bridge](img/walk-facts_bridge_large.png)

And set up your bridge definition that is allowing to create such relation :

![define bridge](img/walk-facts_bridge2_large.png)

Eventually, we can deploy the cube and run this MDX query to check the many-to-many :

```
SELECT
    [Dim].[Dim].members on 0
FROM [Cube]
```

### Download

The schema is available for download [here](data/Walkthrough_Facts_Bridge.zip).

Next chapter: [Facts Many-2-Many (Arrays)](facts_many2manyArray.md).

_