## Row to Columns (ETL)

Allows for transforming information available in one column to generate new columns.

The easiest way is to explain with an example :

```
COUNTRY,        YEAR, MEASURE,                               VALUE
Canada,         2010, Health expenditure private (% of GDP), 2.6
Canada,         2010, Health expenditure public (% of GDP) , 6.1
United States,  2010, Health expenditure private (% of GDP), 7.4
United States,  2010, Health expenditure public (% of GDP) , 5.7
```

This table contains a columns, `MEASURE`, which values we would like to convert to new columns. In our example,
one for private and another for public health expenditure.

```
COUNTRY,        YEAR, Health expenditure private (% of GDP), Health expenditure public (% of GDP)
Canada,         2010, 2.6,                                   6.1
United States,  2010, 7.4,                                   5.7
```

Let's explain how to create a transformation `row to columns` to achieve this.

### Creating the Transformation (aka. View)

The first step is to create a `Row to Columns` view and fill the fields.

![row to columns](img/etl_row_cols_large.png)

`Row for Columns` : Row used to generate the multiple columns. For each distinct value on this column
a new measure column is generated.

`Measure columns ` : Measures columns. These columns will generate new columns that start with the measure
column name and end with the values of the `Row for Columns` column. ( `MeasureA Val1`, `MeasureA Val2`, ...),

`New Columns Suffix Names` : New columns suffix names (should be equal to the sorted unique values of the
`Row to Columns` value). icCube can not generate new columns dynamically as we need to bind them statically,
in the schema, so they can be used.

`Table is Already Sorted` : The table used by the view is already sorted. If yes, the view will not cache
the whole table making it less memory consuming. Note, the table needs to be sorted by all columns except
the ones defined by `Measure Columns` and `Row for Columns`.

And it's done, you can click in browse table data, magnifier icon, to see the result in icCube.

### Download

The schema mentioned in this page can be downloaded [here](Walkthrough_ETL_RowToColumns.zip).

Next chapter: [Group By](etl_group_by.md) describes how to perform some group by operations.

_
