## GeoCoding (ETL)

The GeoCoding transformation allows to generate latitude and longitude coordinates from address data. 
This can be useful for using [Google Map widgets](../../../dashboards/widgets/Maps.md).

Example input:

```
name        ,address                                            ,train station
icCube new  ,Av du Tir Federal 56 1024 Ecublens Switzerland     ,true
icCube old  ,Route de la Pierre 22 1024 Ecublens Switzerland    ,false
```

This table includes the `address` column, for which we want to retrieve latitude and longitude coordinates. 

### Creating the Transformation (aka. View)

Create a `GeoCoding` view and select the data table above that contains the addresses.

In the `Address` field, select the column containing the address data, i.e. `address`.

The output will include two new columns with latitude and longitude of each row address:

![geocoding](img/etl_geocoding.png)

Optionally set the `Lookup language` and enable the `Add Found Address` to return the address of a known location.



### Download

The schema mentioned in this page can be downloaded [here](data/Walkthrough_GeoCoding.zip).

Next chapter: [Dimensions](dimensions.md) describes how to build dimensions and hierarchies.

_
