## User Defined

No matter how many different types of data sources are available, and how many are shipped with the icCube,
there will still be a need for specific requirements on accessing the raw data which schemas are built from.

Because of this, the icCube plugin framework allows you to add new types of data sources. It will then make
no difference to other schema components what data source you are using. They will use such data sources as
native ones. Examples of such data sources are IoT sensors, binary files, etc...

For example, below is a non-exhaustive list of cases where creating a new type of data source is appropriate:

* No native icCube data source is available and for *performance* reasons you do not want to create a conversion
  tool to adapt your data to a supported data source.

* No database server is available and your data are in a proprietary format.

Next chapter: [Real-Time Data Sources](datasources_rt.md) describes real-time datasources used to create schemas
being updated with new data.

_

