## Time Wizard Dimension

Please refer to this [page](../../mdx_tutorial/dimensions.md) for a quick introduction of the dimension concept.

### Overview

Allows us to define/generate a time dimension without any underlying data table. Note that the member keys
of this dimension are of type date unless the option `Time Divisions` is activated.

The `Time Divisions` allows to define a hierarchy with relative time periods. For example, you can define
a flat level with the week's days (Monday, Tuesday, ..., Sunday) without the information of months or years.
The Monday member with match all Monday's of the time dimension. Note, this levels cannot be part of the
default hierarchy as they do not define the key as a valid date to map fact rows.

**Weeks**

The week definition depends on the **country** of the locale as defined in the time dimension (or hierarchy).
Note that using for example English (`en`) or French (`fr`) locale is not enough as they do not define any
country : use instead United States (`en_US`) or France (`fr_FR`) to ensure the weeks are properly defined.

### Walkthrough

We want to generate a time dimension with multiple hierarchies. The hierarchy will begin on August 1st, 2013
and will end on December 31, 2014.

**The First Hierarchy : Time**

It is a classical multilevel one with Year, Quarter, Month and Day levels.

**The Second Hierarchy : Time Pyramide**

It is a special one where the Month level starts July 1st. This allows to define more details when closer
to the current date.

**The Other Hierarchies**

They define the different levels with `Time Divisions` active.

The `Time Weekday` hierarchy (with `Time Divisions`) is shown below :

![time wizard](img/walk-dim-timewiz-hierarchy_large.png)

### Download

The best is downloading the time wizard schema and playing with it in your icCube installation.
The schema is available for download [here](data/Walkthrough_Time_Wizard.zip).

Next chapter: [Facts](facts_intro.md) is describing how to build facts.

_
