## Reverse Index

The reverse index allows for improved MDX query performances (i.e., non-empty crossjoins).

### Overview

A Reverse Index is a feature that appends a new fact column to each measure group containing a single member of a
hierarchy. It remains inactive in cases where a many-to-many relationship exists. This functionality can be visualized 
as a tabular structure.

The attributes of a dimension are inherently suitable for inclusion in a reverse index.

### Activate

In a schema definition, the reverse index is activated using the configuration definition in the `Tabular` tab 
of the schema `Properties` :

![activate reverse index](img/activate-rev-index.png)    

Note that this settings can be disabled in each facts (aka. measure group) : 

![disable reverse index](img/disable-rev-index.png)

### Memory Usage

Once activated, the memory used by the reverse index can be monitored via the regular schema statistics :

![stats reverse index](img/stats-rev-index.png)

Note that the reverse index is stored as integer facts columns and as such can be stored in memory mapped
files as well. The columns are visible within each facts entry of the statistics file :

```
M : #Sales          :: aggr: count         , data: INTEGER, col: boolean (count), ram: 400B  
M : #Articles       :: aggr: distinct count, data: INTEGER, col: integer        , ram: 9136B
M : #Customers      :: aggr: distinct count, data: INTEGER, col: integer        , ram: 9136B
M : Amount          :: aggr: sum           , data: DOUBLE , col: double         , ram: 17.8KB
M : #Licences       :: aggr: sum           , data: INTEGER, col: integer        , ram: 9136B
M : HierarchyIdx:16 :: aggr: rev-index     , data: INTEGER, col: integer        , ram: 9136B
M : HierarchyIdx:1  :: aggr: rev-index     , data: INTEGER, col: integer        , ram: 9136B
M : HierarchyIdx:4  :: aggr: rev-index     , data: INTEGER, col: integer        , ram: 9136B
M : HierarchyIdx:12 :: aggr: rev-index     , data: INTEGER, col: integer        , ram: 9136B
M : HierarchyIdx:15 :: aggr: rev-index     , data: INTEGER, col: integer        , ram: 9136B
```

The number after each `HierarchyIdx` is an internal integer used to identify each hierarchy. You can find them
in the statistics file searching for `base(index)` in the file; for example, the hierarchy `16` corresponds to
`Purchase Date` : 

```
D : Purchase Date :: members: 2'279

    H : Purchase Date :: base(16), members: 2'279
    
        L : All-Level :: members: 1    , total-ram:56.0B , member-ram:40.0B , parent-ram:16.0B , index-ram:0.00B, name-ram:0.00B , s-names-ram:0.00B, keys-ram:0.00B , s-keys-ram:0.00B, props-ram:0.00B, noBase-ram:0.00B,       
        L : Year      :: members: 6    , total-ram:2232B , member-ram:1264B , parent-ram:24.0B , index-ram:0.00B, name-ram:280B  , s-names-ram:152B , keys-ram:328B  , s-keys-ram:152B , props-ram:32.0B, noBase-ram:0.00B,       
        L : Quarter   :: members: 24   , total-ram:6848B , member-ram:4936B , parent-ram:448B  , index-ram:0.00B, name-ram:512B  , s-names-ram:224B , keys-ram:472B  , s-keys-ram:224B , props-ram:32.0B, noBase-ram:0.00B,       
        L : Month     :: members: 72   , total-ram:25.5KB, member-ram:21.9KB, parent-ram:832B  , index-ram:0.00B, name-ram:1160B , s-names-ram:416B , keys-ram:856B  , s-keys-ram:416B , props-ram:32.0B, noBase-ram:0.00B,       
        L : Day       :: members: 2'176, total-ram:145KB , member-ram:59.5KB, parent-ram:17.3KB, index-ram:0.00B, name-ram:33.6KB, s-names-ram:8832B, keys-ram:17.3KB, s-keys-ram:8832B, props-ram:32.0B, noBase-ram:0.00B,       
```

### MDX Performance

The reverse index is used to improve the processing time of large non-empty crossjoins. You can review their usage
in the logs of the processing an MDX query :

```   
...
[fast-crossjoin] started
[fast-crossjoin] sets materialized (1485 x 5736 x 4061 x 439 x 60559 x 24361 x 858 x 25 x 24)
[fast-crossjoin] setup started
[fast-crossjoin] iterators created
[fast-crossjoin] using reverse index for 1 (properties)
[fast-crossjoin] using reverse index for 2 (buildings)
[fast-crossjoin] using reverse index for 4 (types)
...
```

Next chapter: [Actions](adv_actions.md).

_
