## Startup Sequence

Assuming icCube has been installed into `$install` directory, it contains the following directories:

```
/bin
/lib
/cubes
/plugins
/...
```

The main steps of the startup sequence are as follows:

### 1 - Java Configuration

On Windows, this configuration is contained within the `/bin/icCube.bat` file.
On Unix, this configuration is contained within the `/bin/icCube.sh` file.

### 2 - icCube Configuration

The application is trying to locate its configuration file (`icCube.xml`) using the environment variable:
`ICCUBE_CONFIGURATION`. If not found, the `/bin/icCube.xml` file is used.

### 3 - icCube Log4J Configuration

The LOG4J configuration process is similar and uses the environment variable`ICCUBE_LOG4J_CONFIGURATION`
to locate the `log4.xml` file. Note that the default log directory is: `${user.home}/.icCube/log`.

### 4 - icCube Application Directory Setup (Once)

During the first startup of the icCube server for a given configuration, the application directory
is created and populated using the content of the `$install` directories. Using the default configuration,
this directory is: `${user.home}/icCube-data`.

More details about this directory can be found in this [page](data_directory.md).

### 5 - icCube Services

Eventually, internal services are started and the server is ready to accept incoming HTTP connections
on the port 8282 (default configuration).

Next chapter: [Running Multiple Instances on the Same Machine](multiple_instances.md).

_

