## Sharing the icCube-data Directory

Up until icCube v8.3.0 it is not possible to share the [icCube-data](data_directory.md) directory between different
icCube server instances. A file lock is being used to prevent several instances accessing this folder. This constraint
has been relaxed with icCube v8.4.0. This allows for starting several servers being for example part of a fault-tolerant
solution. You might as well put in place some sort of load-balancing between the different servers for performance 
reason.

### Cluster Configuration

Sharing the icCube data directory is possible as soon as the cluster configuration is activated in the
`icCube.xml` file as following:

    <clusterConfiguration active="true">
    ...
    </clusterConfiguration>

When sharing the `icCube-data` folder, it is more likely that this folder will be *remote*
(e.g., an Azure file storage accessed from several Docker containers). In that context, some folders
should remain local (for performance reasons) and still cannot be shared. Following is a recap of the
folders as described [previously](data_directory.md):

    audit / log / tmp / schemaData                             NOT SHARED ( and LOCAL for performance reasons )
    gviService / oauth2
    
    backup / offline                                           SHARED
    roles / users / tenants
    builder / cubes / scheduler / mdxQueries
    docsRepository / webPub / fileSystemRoot
    
    tenantsData                                                SHARED
        for-each-tenant-directory-id (*)
            backup / offline
            builder / cubes / scheduler / mdxQueries
            docsRepository / webPub
    
    fileSystemRoot                                             SHARED (actual path as configured in icCube.xml)
        ...
        $tenants$
            for-each-tenant-directory-id
                ...
    
    (*) the tenant home directory is created when creating a new tenant and/or using the set-tenant-home-directory request.

### Backup Restore

In this mode, you can restore schema backups, but you cannot restore a schema backup **and** continue to back up
the restored schema.

_