## icCube Server

On top of a Docker container, icCube is available as a ZIP file. **Java 21** is required.

### Windows

Download and unzip the icCube binaries in a folder. An `icCube.bat` is available in the bin directory 
of the icCube install directory. You might need to adjust the actual location of your Java 21 and Java
parameters.

Please refer to this [section](#license-installation) for installing the license.

To stop the icCube server, you can right-click the icCube icon from the system tray
and click the `shutdown` option from the menu.

### Unix (and MacOS)

The shell script `icCube.sh` is available within the `bin` directory of the icCube install
directory. You might need to adjust the location of a Java 21.

Please refer to this [section](#license-installation) for installing the license.

As for Windows, if you're running a Linux distribution with a graphical interface the icCube tray icon
will be visible and the menu available on the right click allows for shutting down the process.

### Access

Once started you can access icCube by opening a browser:

    http://localhost:8282/icCube/console

When evaluating icCube, connect as an anonymous user by leaving blank the username or as `admin` (password: `admin`).

### License Installation

Before using icCube, you'll need to install a valid license. Please [contact-us](www.icCube/request-license) if you've
no license yet.

For an **evaluation/trial** of icCube, you can start icCube and connect to the page :

    http://localhost:8282/icCube/console

Then, connect as `admin` (password: `admin`) user. Note that once the license has been installed, you can connect
as an anonymous user by leaving blank the username.

A single page is then being displayed for registering the license. Use the `Register a License` button to select
and upload the `icCube-4.lic` file received from icCube.

For a **production usage** of icCube, the license file should be directly installed before starting icCube.
For example, when using a Docker, the trial installation as described above is installing the license right
within the image meaning it will be lost when the container is being removed.

- standalone program : copy the `icCube-4.lic` file inside the `/bin` directory of the icCube installation.

- Docker image : please refer to this [page](https://github.com/ic3-software/ic3-docker/blob/main/RUN_ADVANCED.md)
  explaining different bind mounts (and/or volumes) options to make the file `/opt/icCube/bin/icCube-4.lic`
  available in the Docker.

Note that once, this _external_ license is available the possibly installed license used for the evaluation/trial
is being ignored.

Next chapter : [Server (Linux)](server_linux.md).

_
