## Multitenant Overview

With the multitenant option activated, icCube provides every tenant a dedicated and separated environment
(e.g., schema definitions, cubes, backups, reports, etc...). A user logged in a given tenant cannot see
data from another tenant.

### Users/Roles

Using out-of-the-box authentication/authorization, roles and users are globally defined. Every user
is being assigned a given tenant.

Using on-the-fly authentication/authorization, the authentication mechanism is then responsible to assign
each authenticated user his own tenant.

A user defined without tenant is placed within a sort of default environment that corresponds to the
configuration of icCube without any tenant activated (typically `~/icCube-data`). That user cannot see
any data from a defined tenant.

### Administrator

A user with the `Administrator` role is restricted to his tenant configuration but can have access
to some data that are shared amongst all tenants (more on this later in this page: e.g., roles).

A user with the `Administrator` role being not attached to any tenant is called a
**super-administrator** and is possibly seeing data shared amongst all tenants
(more on this later in this page: e.g., tenants, users). Note that a super-administrator
can impersonate any tenant via the administration UI and then accomplish any action available
as if this tenant (e.g., manager Reporting applications).

### Environment

The following table details which data is private to a given tenant.

| Data                   | Private  | Description                                                                                                                                                                      |
|------------------------|----------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Tenants                |          | Only a super-administrator can manage the tenants available in the server.                                                                                                       |
| Roles                  |          | A user with the "Administrator" role has access to all available roles.                                                                                                          |
| Users                  |          | A super-administrator has access to all available users in all tenants. On the other hand an "Administrator" for a given tenant has access to all available users in his tenant. |
| Schemas                | &#10004; | Available deployed schemas.                                                                                                                                                      |
| Schemas Data           | &#10004; | Live data of deployed schemas (e.g., memory mapped files).                                                                                                                       |
| Backups/Snapshots      | &#10004; |                                                                                                                                                                                  |
| Scheduler/Alerts       | &#10004; |                                                                                                                                                                                  |
| MDX Queries            | &#10004; | As available in the MDX IDE.                                                                                                                                                     |
| Docs Repository        | &#10004; | Along with dedicated reports, a tenant can have his own Reporting application.                                                                                                   |
| Web Public Repository  |          | The Web public directory is currently shared between all tenants. Should you want to remove editing access remove the editor access rights from the user's role.                 |
| File Public Repository | &#10004; |                                                                                                                                                                                  |
| Builder                | &#10004; |                                                                                                                                                                                  |
| Log Files              |          | A user with the "Administrator" role has access to the log files of the server.                                                                                                  |

Next chapter : [Configuration](multitenant_configuration.md) is describing how to configure the multitenancy.

_