## Migrating icCube : 8.2.2 to 8.3.0

### Server

The icCube 8.3.0 server is backward compatible with icCube 8.2.2.

The format of the reports/dashboards (Dashboards v8) saved in the Docs has been changed. icCube is migrating the Docs
repository but please **read carefully** the next section.

**Before starting icCube v8.30, please ensure to back up your icCube-data/docsRepository first**. You can delete
as well the content of the `icCube-data/log` folder for easier troubleshooting in case of migration issue later.

### Reports/Dashboards

Each report/dashboards definition is not saved anymore into a folder (`.icc-report`) containing its definition
(`report-definition.icc-report-def`). Rather, the `.icc-report` entities are now files.

Upon startup icCube is going to migrate your existing `ic3-reporting/data` folder. The existing folders are not
modified and are renamed with `.deprecated` in their names in case you'd like to rollback. In case of any issue,
you can search the logs for the `[docs] migrate` pattern.

The following folders are being moved :

```
/data/shared                                 -- Dashboards
/data/users                                  -- Dashboards
```

to:

```
/data/gizmos/dashboards/shared
/data/gizmos/dashboards/users
```

Where each existing report/dashboard is being changed from :

```
/data/shared/
    my-report.icc-report/                    -- Dashboard Folder
        report-definition.icc-report-def     -- Dashboard Definition
```

to:

```
/data/shared/
    my-report.icc-report                     -- Dashboard Definition (was the .icc-report-def above)
```

The permissions (`.icc-meta` files) attached to the folders and files should be migrated as well. In case of issue,
you can search the logs for the `[X]` pattern.

**Manual imports (restores)** from a previous Docs format (i.e., exported ZIP files) are automatically migrated.
The ZIP file is being processed to perform the same logic as described above. The migrated content is the imported
(there will be no deprecated folder in the Docs).

### Report/Dashboard Applications

For consistency purpose, report/dashboard applications can be saved into the `/shared` or `/users` folder and be
attached some permissions. The application definition files are now ending with the `.icc-app` extension.

In case of **manual import (restore)** from a previous Docs format (i.e., exported ZIP file), you'll have to manually
rename the imported files.

The following folder is being moved :

```
/data/entities/applications                  -- Dashboards Applications
```

to:

```
/data/gizmos/applications/shared
```

The behavior of the permissions defined for report/dashboard application has been changed to be consistent with
dashboards (and other files/folders in the Docs) permissions. Let us know if there is something wrong for your
scenario.

### Tenants

The `docsRepository` of each tenant is migrated on-demand; you can log as an `Administrator` and impersonate each
tenant to ensure everything is fine.

In any case, [contact us](https://www.iccube.com/contact-us/) if you need any help.

_