## Environment Variables

The variable `ICCUBE_CONFIGURATION`, when defined, references the `icCube.xml` file to use instead of
the default one (`$install/bin/icCube.xml`). See [JRE Options](jre_options.md) for an alternate configuration
using a Java system property.

The variable `ICCUBE_LOG4J_CONFIGURATION`, when defined, references the `log4j.xml` file to use instead of
the default one (`$install/bin/log4j.xml`). See [JRE Options](jre_options.md) for an alternate configuration
using a Java system property.

The variable `ICCUBE_LICENSE`, when defined, references the `icCube-4.lic` file to use instead of
the default one (`$install/bin/icCube-4.lic`). See [JRE Options](jre_options.md) for an alternate configuration
using a Java system property.

The environment variable `ICCUBE_SECRET_KEY`, when defined, specifies a Base64 string encoding a 16 bytes array. 
This value is then used to encrypt/decrypt **all** passwords and API keys (used in `icCube.xml`, `icCube-notification.xml`). 
Changing this key will invalidate **all** existing passwords and API keys.

### icCube.xml 

Environment variables can be used wherever a Java system property can be used.

For example, the following string :

    ${env:SERVER:-localhost}

will be replaced by the value of the `SERVER` variable or `localhost` if the variable is not defined.

### Schema Definition

The XML definition of a schema can contain references to existing environment variables that will be replaced
at runtime by their actual values. For example, the following string :

```
${env:JDBC_SERVER:-localhost}
```

will be replaced by the value of the `JDBC_SERVER` variable or `localhost` if the variable is not defined.

See the following documentation for more details about different parts of the schema definition:

- [JDBC datasource](../schemas_cubes/ds_database.md)

Next chapter : [Java JRE Options](jre_options.md).

_

