## MDX / JAVA Integration

icCube natively integrates JAVA, which is accessible directly from an MDX query.

### Configuration

Java libraries are made available from both MDX expressions and schema data views (aka. ETL).

**CLASSPATH**

No specific configuration is required to access JAVA classes. All the classes accessible by the icCube server
are potentially available. However, if you need JAVA classes from JARs that are not available with icCube,
simply add them to the `icCube-install/lib` directory.

**icCube.xml**

The MDX/JAVA integration can be (de)activated via the `javaMdxNativeConfiguration` section in the
[icCube.xml](../user_guide/configuring_iccube/iccube_xml.md) file.

### MDX Java Native Functions

icCube allows for defining new [functions](../mdx/Declared%20Functions.md) that can be used in MDX statements. 
Such a function can be declared using the Java language. 

As an example the following is generating a random vector using the `ISAAC` generator form Apache `Math3`:

    CREATE NATIVE FUNCTION isaacVector( long seed, int length ) AS
    /* JAVA : double[]

        import org.apache.commons.math3.random.ISAACRandom;


        final ISAACRandom generator = new ISAACRandom(seed);

        final double[] values = new double[length];

        for(int ii = 0; ii < length; ii++)
        {
            values[ii ] = generator.nextInt();
        };

        return values;

    */

Each function is actually defined into <b> its own class</b>. The name of the function is used both for the name of 
the generated class and for the name of the static method. For example, the above function is compiled as following:

```java
package icCube.nativeFunctions;

import java.lang.*;
import java.util.*;

import org.joda.time.*;

import crazydev.iccube.pub.olap.*;
import crazydev.iccube.pub.utils.*;

import org.apache.commons.math3.random.ISAACRandom;

public class isaacVector
{
    public static double[] isaacVector(int p )
    {
        final ISAACRandom generator = new ISAACRandom(seed);

        final double[] values = new double[length];

        for(int ii = 0; ii < length; ii++)
        {
            values[ii ] = generator.nextInt();
        };

        return values;
    }

}

```

You can use a <b>static import</b> to refer to a native function from a native function. For example, the following 
function is using the `isaacVector()` function to retrieve a random value :

    CREATE NATIVE FUNCTION f() AS
    /* JAVA : double

        import static icCube.nativeFunctions.isaacVector.*;

        return isaacVector( 42, 1 )[0];

    */

When defining a native function, you can define its **return type** as following :

    CREATE NATIVE FUNCTION function-name() AS
    /* JAVA : return-type
        ...

If no return type has been specified then `Object` is being assumed. Therefore, you'll need to cast it accordingly 
when using the native function from another native function. For example, if the `isaacVector()` would have been
defined without any return type : 

    CREATE NATIVE FUNCTION isaacVector( long seed, int length ) AS
    /* JAVA 

        import org.apache.commons.math3.random.ISAACRandom;
        ...

Then using it to retrieve an element of the vector would require a cast :

    CREATE NATIVE FUNCTION f() AS
    /* JAVA

        import static icCube.nativeFunctions.isaacVector.*;

        return ((double[])isaacVector( 42, 1 ))[0];

    */

The following **parameter types** are available:

    JAVA types:

        double  ( Double  )
        float   ( Float   )
        long    ( Long    )
        int     ( Integer )
        boolean ( Boolean )

        String

    JODA Date/Time

        LocalDate
        LocalDateTime

    IOlapScalar

        /**
         * Null scalar/value: IOlapScalar methods typically return an empty value instead of Java null.
         */
        boolean isEmpty();

    IOlapNumeric extends IOlapScalar

        boolean isDecimal();
        boolean isDouble();

        double  value();

        double  doubleValue();
        float   floatValue();
        long    longValue();
        int     intValue();

    IOlapDoubleVector extends IOlapScalar (*)

        int           size();
        double        get(int index);

    IOlapComparableList extends IOlapScalar

        int           size();
        Comparable    get(int index);

        String        getAsDate(int index);
        LocalDate     getAsDate(int index);
        LocalDateTime getAsDateTime(int index);

(*) The `IOlapDoubleVector` contains all methods defined in [Vector( MDX++ )](../mdx_types/vector.md) as well.

**NULL/Empty Parameters and Return Values**

Passing an MDX null entity to a parameter whose type is primitive will generate an error. This might happen when
you evaluate an MDX tuple and the result is empty. To handle properly those scenarios you can use an object,
for example `Double` instead of `double` as parameter type; in that case a null Java is being sent.

If you want to return a null/empty, simply return a Java `null` value.

_