## icCube XMLA Properties

Here is the list of icCube XMLA properties along with their description.


### icCube.mdxEvalLambdaProcessingMode

Description : Activate lambda processing options (defaulted to : SET_CALC | PARALLEL_AXIS).
Read-Only   : no 

### icCube.calcMemberDefinedUniqueName

Description : When true, the unique name of the calc. measure/member is the full name used for its declaration (i.e., not internally generated).
Read-Only   : no 

### icCube.toStrMaxSize

Description : The maximum length of a string generated by the MDX .StrToXyz() function; generate an error when the size is exceeded.
Read-Only   : no 

### icCube.excelFixXsdLong

Description : When set to true, cell value types are possibly considered as xsd:int instead of their native xsd:long type.
Read-Only   : no 

### icCube.loadProcessingFactsMode

Description : Configuration that controls how the facts are built.
Read-Only   : yes 

### icCube.defaultFormatStringSyntax

Description : icCube supports both Excel and JAVA FORMAT_STRING syntax : this property defines the default syntax to use.
Read-Only   : no 

### icCube.singleMdxEvalThreadCount

Description : ( deprecated : see mdxEvalConfiguration ) Maximum number of threads for (single) MDX request evaluation (-1 means number of cores, 0 means sequential processing).
Read-Only   : yes 

### icCube.activeLoadCount

Description : Maximum number of active LOAD requests.
Read-Only   : yes 

### icCube.drillthroughDefaultMaxRows

Description : Maximum number of rows returned by a DRILLTHROUGH statement when its MAXROWS is not specified.
Read-Only   : no 

### icCube.indexFileBufferSize

Description : Index file buffer size in 32 bits integer count ( 2 ^ N ).
Read-Only   : yes 

### icCube.singleMdxExtraEvalQueueSize

Description : ( deprecated : see mdxEvalConfiguration ) Maximum number of queued tasks for (single) MDX extra. request evaluation.
Read-Only   : yes 

### icCube.mdxEvalMeasureVector

Description : Activate fast processing when several [Measures] are specified on an axis (defaulted to true).
Read-Only   : no 

### icCube.factsColumnBufferSize

Description : Facts buffer size.
Read-Only   : yes 

### icCube.factsColumnFileSize

Description : Facts file size (-1: unlimited size).
Read-Only   : yes 

### icCube.loadProcessingQueueSize

Description : Maximum number of queued tasks for LOAD (processing) request processing.
Read-Only   : yes 

### icCube.excelFixDotMembers

Description : When set to true, MDX queries are possibly modified on the fly to fixed wrong Excel pivot table queries.
Read-Only   : no 

### icCube.singleMdxEvalQueueSize

Description : ( deprecated : see mdxEvalConfiguration ) Maximum number of queued tasks for (single) MDX request evaluation.
Read-Only   : yes 

### icCube.maxUnresolvedRowsCount

Description : Maximum number of unresolved rows per facts table to keep in memory for processing during the next incremental load. If that maximum amount is reached an error is generated.
Read-Only   : no 

### icCube.mdxQueryCacheMax

Description : Maximum number of tuples being cached during the processing of a MDX query.
Read-Only   : no 

### icCube.initialNonEmptyMaxRow

Description : This property defines the number of non-empty evaluation for sets participating in non-empty crossjoin.
Read-Only   : no 

### icCube.duplicatedSolveOrderError

Description : When set to true, an error is generated when attempting to use calculated members with ambiguous SOLVE_ORDER definition.
Read-Only   : no 

### icCube.calcMemberMaxEvaluationFrameStackSize

Description : The maximum number of calculated member nested calls (i.e., calc-member of calc-member of ...); allows for preventing infinite loop.
Read-Only   : no 

### icCube.loadReadingQueueSize

Description : Maximum number of queued tasks for LOAD (reading) request processing.
Read-Only   : yes 

### icCube.functionMaxEvaluationFrameStackSize

Description : The maximum number of function (i.e., WITH FUNCTION) nested calls (i.e., f() calling g() calling h() calling ...); allows for preventing infinite loop.
Read-Only   : no 

### icCube.mdxQueryCalcMemberCacheMode

Description : Define the type of calculated member cache used during the processing of a MDX query (NONE, ALL, ON_DEMAND).
Read-Only   : no 

### icCube.resultCacheSize

Description : MDX request result cache size (MB).
Read-Only   : no 

### icCube.localeIdentifier

Description : Language/country identifier.
Read-Only   : no 

### icCube.factFileSize

Description : Maximum size (byte) of fact files.
Read-Only   : yes 

### icCube.cleanerActive

Description : (Windows only) facts file cleaner running in the background.
Read-Only   : yes 

### icCube.cleanerDelay

Description : (Windows only) determines the delay in seconds between each run.
Read-Only   : yes 

### icCube.pivotTableCellVectorFValueGviSize

Description : This property defines the maximum number of vector items sent in the FORMATTED_VALUE of the pivot table cells (GVI).
Read-Only   : no 

### icCube.indexFileSize

Description : Index file size in 32 bits integer count ( 2 ^ N ).
Read-Only   : yes 

### icCube.mdxQueryCalcMemberCacheMax

Description : Maximum number of calculated members being cached during the processing of a MDX query.
Read-Only   : no 

### icCube.indexBufferSize

Description : Index buffer size in 32 bits integer count ( 2 ^ N ).
Read-Only   : yes 

### icCube.factsIndexFileSize

Description : Index file size (-1: unlimited size).
Read-Only   : yes 

### icCube.selectCellMaxCount

Description : ( deprecated : see mdxEvalConfiguration ) Maximum number of cell returned by a SELECT statement.
Read-Only   : no 

### icCube.olapEngineSimultaneousRequestCount

Description : Maximum number of simultaneous requests within the MDX engine.
Read-Only   : yes 

### icCube.defaultHierarchyAllMemberName

Description : This property defines the default name of the hierarchy all member.
Read-Only   : no 

### icCube.loadReadingThreadCount

Description : Maximum number of threads for LOAD (reading part) request evaluation (-1 means number of cores, 0 means sequential processing).
Read-Only   : yes 

### icCube.setDimensionalityCheck

Description : Experimental.
Read-Only   : no 

### icCube.factFileBufferSize

Description : Buffer size (byte) of fact files.
Read-Only   : yes 

### icCube.excelFixFilterHelperSet

Description : When set to true, MDX queries are possibly modified on the fly to fixed wrong Excel pivot table queries.
Read-Only   : no 

### icCube.mdxCrossjoinWithAttributes

Description : Use attributes for fast crossjoin to improve performance
Read-Only   : no 

### icCube.mdxEvalUnknownMemberError

Description : When set to true, usage of unknown MDX entities is generating an error; otherwise a NULL value is used instead.
Read-Only   : no 

### icCube.nonEmptyBehaviorSetupMode

Description : Define how the calculated member NON EMPTY BEHAVIOR setup (MANUAL, AUTO).
Read-Only   : no 

### icCube.dimensionalityCheck

Description : When activated checks that axis and calculated members do not define a tuple with two members of the same hierarchy (as in SaaS).
Read-Only   : no 

### icCube.dimensionCubeNameUnique

Description : This property defines whether a dimension name can be used as a cube name.
Read-Only   : no 

### icCube.factsIndexFileBufferSize

Description : Index file buffer size.
Read-Only   : yes 

### icCube.loadProcessingThreadCount

Description : Maximum number of threads for LOAD (processing part) request evaluation (-1 means number of cores, 0 means sequential processing).
Read-Only   : yes 

### icCube.mdxEvalSetCalculatorMinSize

Description : Minimum size of the set to activate fast set calculators in TopCount() like function.
Read-Only   : no 

### icCube.dimMemBufferSize

Description : Buffer size (byte) of in-memory dimension.
Read-Only   : yes 

### icCube.mdxEvalFilterProcessingMode

Description : Define the type of evaluation of the Filer and NonEmpty function (LAMBDA, ITERATOR).
Read-Only   : no 

### icCube.factsResolveMemberLruCacheSize

Description : Size of the LRU cache used to resolve members while processing the facts.
Read-Only   : yes 

### icCube.visualMode

Description : Whether or not the axes are evaluated as if VisualTotals was used. Possible values are : VISUAL_TOTAL, NON_VISUAL_TOTAL.
Read-Only   : no 

### icCube.maxTablePartitionCount

Description : Maximum number of table partitions (-1 means no limit); a few number of partitions is typically expected.
Read-Only   : no 

### icCube.resultCachePolicy

Description : Determines when MDX requests can be cached.
Read-Only   : no 

### icCube.mdxQueryCellCacheMax

Description : Maximum number of tuples being cached during the processing of a cell of a MDX query.
Read-Only   : no 

### icCube.mdxEvalFastNonEmptyAxis

Description : Activate fast processing of NON EMPTY axes (defaulted to true).
Read-Only   : no 

### icCube.resultCacheMode

Description : This flag activates the MDX request result cache and its mode (OFF, MEMORY, FILE).
Read-Only   : no 

### icCube.activeMdxRequestCount

Description : ( deprecated : see mdxEvalConfiguration ) Maximum number of active MDX requests.
Read-Only   : yes 

### icCube.singleMdxExtraEvalThreadCount

Description : ( deprecated : see mdxEvalConfiguration ) Maximum number of threads for (single) MDX extra. request evaluation (-1 means number of cores, 0 means sequential processing).
Read-Only   : yes 

### icCube.factMemBufferSize

Description : Buffer size (byte) of in-memory facts.
Read-Only   : yes 

### icCube.factsIndexBufferSize

Description : Index buffer size.
Read-Only   : yes 

### icCube.loadReadingRowBatch

Description : Number of rows processed by each LOAD request READING task.
Read-Only   : yes 

### icCube.maxBufferSizeForCachingIterator

Description : Maximum number of tuples being cached in MDX set iterators.
Read-Only   : yes 

### icCube.cleanerFileCount

Description : (Windows only) determines the maximum number of files being deleted during each run (-1 means no limit - all files available for deletion are tried).
Read-Only   : yes 

### icCube.factsColumnFileBufferSize

Description : Facts file buffer size.
Read-Only   : yes 

### icCube.compactSetInSubSelect

Description : When activated wraps each sub-select axis expression into a CompactSet function call.
Read-Only   : no 

### icCube.defaultHierarchyAllLevelName

Description : This property defines the default name of the hierarchy all level.
Read-Only   : no 

### icCube.mdxSumAlgo

Description : Define how double values are aggregated (aka. sum) to take into account rounding errors (STANDARD, NEUMAIER).
Read-Only   : no 

### icCube.visualTotalsIntermediateMembers

Description : This flag allows for controlling how not set intermediate members are handled in VisualTotals function.
Read-Only   : no 

_