## Monitoring Counters

Here is the list of icCube monitoring counters. Note that the list of available counters might change from one JVM to another.


### Process

|Name|Description|
|-|-|
|Process CPU Time|Returns the 'recent cpu usage' for the Java Virtual Machine process|
|System CPU Time|Returns the 'recent cpu usage' for the whole system|

### Memory

|Name|Description|
|-|-|
|Memory Pool - CodeHeap 'non-nmethods' (Mb)|Returns the amount of used memory in megabytes for the memory pool|
|Memory Pool - CodeHeap 'non-nmethods' %|Returns the percent of used memory for the memory pool (max. memory as 100%)|
|Memory Pool - Metaspace (Mb)|Returns the amount of used memory in megabytes for the memory pool|
|Memory Pool - Metaspace %|Returns the percent of used memory for the memory pool (max. memory as 100%)|
|Memory Pool - CodeHeap 'profiled nmethods' (Mb)|Returns the amount of used memory in megabytes for the memory pool|
|Memory Pool - CodeHeap 'profiled nmethods' %|Returns the percent of used memory for the memory pool (max. memory as 100%)|
|Memory Pool - Compressed Class Space (Mb)|Returns the amount of used memory in megabytes for the memory pool|
|Memory Pool - Compressed Class Space %|Returns the percent of used memory for the memory pool (max. memory as 100%)|
|Memory Pool - G1 Eden Space (Mb)|Returns the amount of used memory in megabytes for the memory pool|
|Memory Pool - G1 Eden Space %|Returns the percent of used memory for the memory pool (max. memory as 100%)|
|Memory Pool - G1 Old Gen (Mb)|Returns the amount of used memory in megabytes for the memory pool|
|Memory Pool - G1 Old Gen %|Returns the percent of used memory for the memory pool (max. memory as 100%)|
|Memory Pool - G1 Survivor Space (Mb)|Returns the amount of used memory in megabytes for the memory pool|
|Memory Pool - G1 Survivor Space %|Returns the percent of used memory for the memory pool (max. memory as 100%)|
|Memory Pool - CodeHeap 'non-profiled nmethods' (Mb)|Returns the amount of used memory in megabytes for the memory pool|
|Memory Pool - CodeHeap 'non-profiled nmethods' %|Returns the percent of used memory for the memory pool (max. memory as 100%)|
|GC Count - G1 Young Generation|Returns the total number of collections that have occurred for this memory manager|
|GC Time - G1 Young Generation|Returns the approximate accumulated collection elapsed time in milliseconds for this memory manager|
|GC Count - G1 Concurrent GC|Returns the total number of collections that have occurred for this memory manager|
|GC Time - G1 Concurrent GC|Returns the approximate accumulated collection elapsed time in milliseconds for this memory manager|
|GC Count - G1 Old Generation|Returns the total number of collections that have occurred for this memory manager|
|GC Time - G1 Old Generation|Returns the approximate accumulated collection elapsed time in milliseconds for this memory manager|
|Free Memory (Mb)|Returns the amount of free memory in the Java Virtual Machine in megabytes|
|Total Memory (Mb)|Returns the total amount of memory in the Java virtual machine in megabytes|

### Session

|Name|Description|
|-|-|
|HTTP Session Count|Returns the number of open HTTP sessions.|

### Request

|Name|Description|
|-|-|
|Total Load Request Count|Returns the total number of load (schema) requests since the last startup of the server.|
|Total Load Request Time|Returns the approximate accumulated load (schema) request elapsed time in milliseconds since the last startup of the server.|
|Total MDX Request Count|Returns the total number of MDX requests since the last startup of the server.|
|Total MDX Request Time|Returns the approximate accumulated MDX request elapsed time in milliseconds since the last startup of the server.|
|Total Other Request Count|Returns the total number of other (as opposed to MDX and load) requests since the last startup of the server.|
|Total Other Request Time|Returns the approximate accumulated other (as opposed to MDX and load) request elapsed time in milliseconds since the last startup of the server.|

### Executor

|Name|Description|
|-|-|
|Request Task Queue Size|Instant number of request tasks within the request executor; a request is split into tasks before being executed.|
|MDX Request Task Queue Size (server default)|Instant number of MDX tasks within the MDX request (server default) executor.|
|Table Load Task Queue Size|Instant number of tasks within the load schema request executor (loading tables).|
|Table Processing Task Queue Size|Instant number of tasks within the load schema request executor (processing tables).|

_

