## MDX Functions Reference

This section describes the standard MDX functions. Each function is illustrated with several working examples.

### Color

* [HSL](HSL.md)
* [HSV](HSV.md)
* [InterpolateHSVColors](InterpolateHSVColors.md)
* [InterpolateRGBColors](InterpolateRGBColors.md)
* [RGB](RGB.md)

### Logical

* [CoalesceEmpty](CoalesceEmpty.md)
* [CoalesceNull](CoalesceNull.md)
* [Iif](Iif.md)
* [IsAll](IsAll.md)
* [IsAncestor](IsAncestor.md)
* [IsDefault](IsDefault.md)
* [IsEmpty](IsEmpty.md)
* [IsFiltering](IsFiltering.md)
* [IsGeneration](IsGeneration.md)
* [IsLeaf](IsLeaf.md)
* [IsSibling](IsSibling.md)
* [IsUnknown](IsUnknown.md)

### Member

* [Ancestor](Ancestor.md)
* [ClosingPeriod](ClosingPeriod.md)
* [ContextMember](ContextMember.md)
* [ContextMembers](ContextMembers.md)
* [Cousin](Cousin.md)
* [Current](Current.md)
* [CurrentMember](CurrentMember.md)
* [DefaultMember](DefaultMember.md)
* [FirstChild](FirstChild.md)
* [FirstSibling](FirstSibling.md)
* [GetProperty](GetProperty.md)
* [IsDayLevel](IsDayLevel.md)
* [IsHalfYearLevel](IsHalfYearLevel.md)
* [IsMonthLevel](IsMonthLevel.md)
* [IsQuarterLevel](IsQuarterLevel.md)
* [IsWeekLevel](IsWeekLevel.md)
* [IsYearLevel](IsYearLevel.md)
* [Lag](Lag.md)
* [LastChild](LastChild.md)
* [LastSibling](LastSibling.md)
* [Lead](Lead.md)
* [LinkMember](LinkMember.md)
* [LookupByKey](LookupByKey.md)
* [LookupByKeys](LookupByKeys.md)
* [LookupByName](LookupByName.md)
* [MemberValue](MemberValue.md)
* [NameToSet](NameToSet.md)
* [NextMember](NextMember.md)
* [OpeningPeriod](OpeningPeriod.md)
* [ParallelPeriod](ParallelPeriod.md)
* [Parent](Parent.md)
* [PrevMember](PrevMember.md)
* [Properties](Properties.md)
* [SetProperty](SetProperty.md)
* [UnknownMembers](UnknownMembers.md)

### Monitoring

* [GetMonitoringCounter](GetMonitoringCounter.md)
* [SchemaRefreshTime](SchemaRefreshTime.md)
* [SchemaUpdateTime](SchemaUpdateTime.md)
* [UserLanguage](UserLanguage.md)
* [UserLocale](UserLocale.md)
* [UserName](UserName.md)

### Numeric

* [AddN](AddN.md)
* [Aggregate](Aggregate.md)
* [Avg](Avg.md)
* [Correlation](Correlation.md)
* [Count](Count.md)
* [Count(Dimensions)](Count(Dimensions).md)
* [Count(Level)](Count(Level).md)
* [Count(Levels)](Count(Levels).md)
* [Covariance](Covariance.md)
* [CovarianceN](CovarianceN.md)
* [CurrentCellValue](CurrentCellValue.md)
* [Distinct](Distinct.md)
* [DistinctCount](DistinctCount.md)
* [Divide](Divide.md)
* [DivN](DivN.md)
* [ElementValue](ElementValue.md)
* [Eval](Eval.md)
* [EvalEntity](EvalEntity.md)
* [LinRegIntercept](LinRegIntercept.md)
* [LinRegPoint](LinRegPoint.md)
* [LinRegR2](LinRegR2.md)
* [LinRegSlope](LinRegSlope.md)
* [Matrix](Matrix.md)
* [MatrixA](MatrixA.md)
* [MatrixN](MatrixN.md)
* [Max](Max.md)
* [Median](Median.md)
* [Min](Min.md)
* [MinusN](MinusN.md)
* [Percentile](Percentile.md)
* [PercN](PercN.md)
* [Prod](Prod.md)
* [SetAxes](SetAxes.md)
* [Stddev](Stddev.md)
* [StddevP](StddevP.md)
* [Stdev](Stdev.md)
* [StdevP](StdevP.md)
* [Sum](Sum.md)
* [SumOn](SumOn.md)
* [Value](Value.md)
* [Var](Var.md)
* [Variance](Variance.md)
* [VarianceP](VarianceP.md)
* [VarP](VarP.md)
* [Vector](Vector.md)
* [VectorA](VectorA.md)
* [VectorK](VectorK.md)
* [VectorN](VectorN.md)
* [VectorS](VectorS.md)
* [WAvg](WAvg.md)

### Other

* [Caption](Caption.md)
* [Description](Description.md)
* [Dimension](Dimension.md)
* [Dimensions](Dimensions.md)
* [Error](Error.md)
* [FirstNotAllLevel](FirstNotAllLevel.md)
* [GetPropertyUniqueValues](GetPropertyUniqueValues.md)
* [Hierarchy](Hierarchy.md)
* [IsError](IsError.md)
* [LastLevel](LastLevel.md)
* [Level](Level.md)
* [Levels](Levels.md)
* [ListScalars](ListScalars.md)
* [Name](Name.md)
* [Ordinal](Ordinal.md)
* [SubCubeComplement](SubCubeComplement.md)
* [SubCubeIntersect](SubCubeIntersect.md)
* [SubCubeMinus](SubCubeMinus.md)
* [SubCubeOthers](SubCubeOthers.md)
* [SubCubeSymDifference](SubCubeSymDifference.md)
* [SubCubeUnion](SubCubeUnion.md)
* [UniqueName](UniqueName.md)

### Set

* [AddCalculatedMembers](AddCalculatedMembers.md)
* [AllMembers](AllMembers.md)
* [Ancestors](Ancestors.md)
* [Ascendants](Ascendants.md)
* [Axis](Axis.md)
* [BottomCount](BottomCount.md)
* [BottomPercent](BottomPercent.md)
* [BottomSum](BottomSum.md)
* [Children](Children.md)
* [CompactSet](CompactSet.md)
* [Crossjoin](Crossjoin.md)
* [CurrentOrdinal](CurrentOrdinal.md)
* [Descendants](Descendants.md)
* [DrilldownLevel](DrilldownLevel.md)
* [DrilldownLevelBottom](DrilldownLevelBottom.md)
* [DrilldownLevelTop](DrilldownLevelTop.md)
* [DrilldownMember](DrilldownMember.md)
* [DrilldownMemberBottom](DrilldownMemberBottom.md)
* [DrilldownMemberTop](DrilldownMemberTop.md)
* [DrillUpLevel](DrillUpLevel.md)
* [DrillUpMember](DrillUpMember.md)
* [Except](Except.md)
* [Exists](Exists.md)
* [Expand](Expand.md)
* [Extract](Extract.md)
* [ExtractOthers](ExtractOthers.md)
* [Filter](Filter.md)
* [Generate](Generate.md)
* [GetFilterInfo](GetFilterInfo.md)
* [Head](Head.md)
* [Hierarchize](Hierarchize.md)
* [IndexOf](IndexOf.md)
* [Intersect](Intersect.md)
* [IsIn](IsIn.md)
* [Item](Item.md)
* [LastPeriods](LastPeriods.md)
* [MeasureGroupMeasures](MeasureGroupMeasures.md)
* [Members](Members.md)
* [Mtd](Mtd.md)
* [NonEmpty](NonEmpty.md)
* [NonEmptyMembers](NonEmptyMembers.md)
* [NonEmptyX](NonEmptyX.md)
* [Order](Order.md)
* [PeriodsToDate](PeriodsToDate.md)
* [Qtd](Qtd.md)
* [Range](Range.md)
* [Rank](Rank.md)
* [RemoveUnknown](RemoveUnknown.md)
* [Replicate](Replicate.md)
* [Reverse](Reverse.md)
* [Siblings](Siblings.md)
* [Slicer](Slicer.md)
* [StripCalculatedMembers](StripCalculatedMembers.md)
* [SubSelectAxis](SubSelectAxis.md)
* [Subset](Subset.md)
* [Tail](Tail.md)
* [TopCount](TopCount.md)
* [TopPercent](TopPercent.md)
* [TopSum](TopSum.md)
* [Union](Union.md)
* [Unorder](Unorder.md)
* [UpperCrossjoin](UpperCrossjoin.md)
* [VisualTotals](VisualTotals.md)
* [Wtd](Wtd.md)
* [Ytd](Ytd.md)
* [Zip](Zip.md)

### String

* [MemberToStr](MemberToStr.md)
* [PatternMatches](PatternMatches.md)
* [PatternMatchesContains](PatternMatchesContains.md)
* [PatternMatchesEndsWith](PatternMatchesEndsWith.md)
* [PatternMatchesEquals](PatternMatchesEquals.md)
* [PatternMatchesStartsWith](PatternMatchesStartsWith.md)
* [SetToStr](SetToStr.md)
* [StrToHierarchy](StrToHierarchy.md)
* [StrToLevel](StrToLevel.md)
* [StrToMember](StrToMember.md)
* [StrToSet](StrToSet.md)
* [StrToTuple](StrToTuple.md)
* [StrToValue](StrToValue.md)
* [TupleToStr](TupleToStr.md)

### Time Intelligence

* [dtAsOf](dtAsOf.md)
* [dtAsOfToday](dtAsOfToday.md)
* [dtAsOfYesterday](dtAsOfYesterday.md)
* [dtDatesItd](dtDatesItd.md)
* [dtDatesMfd](dtDatesMfd.md)
* [dtDatesMtd](dtDatesMtd.md)
* [dtDatesQfd](dtDatesQfd.md)
* [dtDatesQtd](dtDatesQtd.md)
* [dtDatesWeek](dtDatesWeek.md)
* [dtDatesWeekend](dtDatesWeekend.md)
* [dtDatesWfd](dtDatesWfd.md)
* [dtDatesWtd](dtDatesWtd.md)
* [dtDatesYfd](dtDatesYfd.md)
* [dtDatesYtd](dtDatesYtd.md)
* [dtFirstDayOfWeekOfMonth](dtFirstDayOfWeekOfMonth.md)
* [dtFirstDayOfWeekOfQuarter](dtFirstDayOfWeekOfQuarter.md)
* [dtFirstDayOfWeekOfYear](dtFirstDayOfWeekOfYear.md)
* [dtGetDayOfMonth](dtGetDayOfMonth.md)
* [dtGetDayOfWeek](dtGetDayOfWeek.md)
* [dtGetDayOfYear](dtGetDayOfYear.md)
* [dtGetMonthOfYear](dtGetMonthOfYear.md)
* [dtGetWeekOfYear](dtGetWeekOfYear.md)
* [dtGetYear](dtGetYear.md)
* [dtLastDayOfWeekOfMonth](dtLastDayOfWeekOfMonth.md)
* [dtLastDayOfWeekOfQuarter](dtLastDayOfWeekOfQuarter.md)
* [dtLastDayOfWeekOfYear](dtLastDayOfWeekOfYear.md)
* [dtMinusDays](dtMinusDays.md)
* [dtMinusMonths](dtMinusMonths.md)
* [dtMinusQuarters](dtMinusQuarters.md)
* [dtMinusWeeks](dtMinusWeeks.md)
* [dtMinusYears](dtMinusYears.md)
* [dtNextDay](dtNextDay.md)
* [dtNextMonth](dtNextMonth.md)
* [dtNextQuarter](dtNextQuarter.md)
* [dtNextWeek](dtNextWeek.md)
* [dtNextYear](dtNextYear.md)
* [dtNthDayOfWeekOfMonth](dtNthDayOfWeekOfMonth.md)
* [dtNthDayOfWeekOfQuarter](dtNthDayOfWeekOfQuarter.md)
* [dtNthDayOfWeekOfYear](dtNthDayOfWeekOfYear.md)
* [dtPlusDays](dtPlusDays.md)
* [dtPlusMonths](dtPlusMonths.md)
* [dtPlusQuarters](dtPlusQuarters.md)
* [dtPlusWeeks](dtPlusWeeks.md)
* [dtPlusYears](dtPlusYears.md)
* [dtPreviousDay](dtPreviousDay.md)
* [dtPreviousMonth](dtPreviousMonth.md)
* [dtPreviousQuarter](dtPreviousQuarter.md)
* [dtPreviousWeek](dtPreviousWeek.md)
* [dtPreviousYear](dtPreviousYear.md)
* [dtRollingMonths](dtRollingMonths.md)
* [dtWithDayOfMonth](dtWithDayOfMonth.md)
* [dtWithDayOfWeek](dtWithDayOfWeek.md)
* [dtWithDayOfYear](dtWithDayOfYear.md)
* [dtWithMonthOfYear](dtWithMonthOfYear.md)
* [dtWithTime](dtWithTime.md)
* [dtWithYear](dtWithYear.md)

### Tuple

* [Root](Root.md)

### Utility

* [DaysBetween](DaysBetween.md)
* [Excel Conversion Functions](Excel%20Conversion%20Functions.md)
* [Excel Date Functions](Excel%20Date%20Functions.md)
* [Excel Numerical Functions](Excel%20Numerical%20Functions.md)
* [Excel Text Functions](Excel%20Text%20Functions.md)
* [ic3drilldownStop](ic3drilldownStop.md)
* [Java Functions](Java%20Functions.md)
* [ValTypeName](ValTypeName.md)
* [VarTypeName](VarTypeName.md)

_


