## dtRollingMonths

Returns the rolling months as a set for the time member parameter (member.dtMinusMonth():member]


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |
| |value-expression |one | |
|compactSet |boolean |zero-one |true |



### Return

```
member|set-members
```



### Description

Returns the rolling month for a time hierarchy member. The level of this member has to be a time dimension with
the level type defined (year,quarter, month,day, hour).

The second parameter defines the number of month to go backwards from the parameter time member.

For a level that are smaller than a month (e.g. week, day, hour ) :

[Time].[Day Level].[1 June].dtMinusMonths(rollingMonths).dtPlusDays(1):[Time].[Day Level].[1 June]

For levels that are month or bigger :

[Time].[Month Level].[June].dtMinusMonths(rollingMonths-1):[Time].[Month Level].[June]

Note that for Quarters and Years the rolling months have to be a multiplier of 3 or 12 (for a Quarter, 3,6,9,12..) as
the start date can not be inside a period.

A negative rolling month value will make the set go forward starting on the parameter time member (included).

By default the resulting set is compacted.



### Since Version

6.6


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtRollingMonths(month-member,2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns two month rolling member for the June 2016.

**Query**

```
dtRollingMonths([Calendar].[2016 Jun],2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Calendar].[Calendar].[Month].&[2016-05-01], 
  [Calendar].[Calendar].[Month].&[2016-06-01]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Calendar].[2016 May]:[Calendar].[2016 Jun]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtRollingMonths(month-member,-2) - forward

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns two month rolling member from the June 2016 in reverse mode (starts on June 2016).

**Query**

```
dtRollingMonths([Calendar].[2016 Jun],-2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Calendar].[Calendar].[Month].&[2016-06-01], 
  [Calendar].[Calendar].[Month].&[2016-07-01]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Calendar].[2016 Jun]:[Calendar].[2016 Jul]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtRollingMonths(month-member,12) - compactSet example

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns twelve month rolling member from the Dec 2016.

**Query**

```
dtRollingMonths([Calendar].[2016 Dec],12)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Calendar].[Calendar].[Year].&[2016-01-01]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Calendar].[2016]
```


**Assertion : MDX Equals**

```
compactSet( {[Calendar].[2016 Jan]:[Calendar].[2016 Dec]} )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtRollingMonths(month-member,12,false) - without compactSet

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns twelve month rolling member from the Dec 2016 without compacting.

**Query**

```
dtRollingMonths([Calendar].[2016 Dec],12,false)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Calendar].[Calendar].[Month].&[2016-01-01], 
  [Calendar].[Calendar].[Month].&[2016-02-01], 
  [Calendar].[Calendar].[Month].&[2016-03-01], 
  [Calendar].[Calendar].[Month].&[2016-04-01], 
  [Calendar].[Calendar].[Month].&[2016-05-01], 
  [Calendar].[Calendar].[Month].&[2016-06-01], 
  [Calendar].[Calendar].[Month].&[2016-07-01], 
  [Calendar].[Calendar].[Month].&[2016-08-01], 
  [Calendar].[Calendar].[Month].&[2016-09-01], 
  [Calendar].[Calendar].[Month].&[2016-10-01], 
  [Calendar].[Calendar].[Month].&[2016-11-01], 
  [Calendar].[Calendar].[Month].&[2016-12-01]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Calendar].[2016 Jan]:[Calendar].[2016 Dec]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtRollingMonths(day-member,1)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns one month rolling member for the 20th June.

**Query**

```
dtRollingMonths([Calendar].[Day].[20 Jun 2016],1).count()
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>31</td></tr></table>


**Assertion : MDX Equals**

```
{[Calendar].[Day].[21 May 2016]:[Calendar].[Day].[20 Jun 2016]}.count()
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtRollingMonths(day-member,3)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns three month rolling member for the 20th June (compactSet)

**Query**

```
dtRollingMonths([Calendar].[Day].[20 Jun 2016],3).count()
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>33</td></tr></table>


**Assertion : MDX Equals**

```
CompactSet( {[Calendar].[Day].[21 Mar 2016]:[Calendar].[Day].[20 Jun 2016]} ).count()
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtRollingMonths(year-member,24)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns two years rolling member for 2018

**Query**

```
dtRollingMonths([Calendar].[2018],24)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Calendar].[Calendar].[Year].&[2017-01-01], 
  [Calendar].[Calendar].[Year].&[2018-01-01]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Calendar].[2017],[Calendar].[2018]}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtRollingMonths(member,8) - year  

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to a a year level with a number of month that is not a multiplier of 12

**Query**

```
dtRollingMonths([Calendar].[2016],8)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

dtRollingMonths() : argument (1) type mismatch: expected:'value that is a multiplier of 12', got:'8'  (it's a Year level, you can't start in the middle)</td></tr></table>


 
</div>

                                                                         

### See Also


[dtNextMonth](dtNextMonth.md)

[dtPreviousMonth](dtPreviousMonth.md)

[dtPlusMonths](dtPlusMonths.md)

[dtMinusMonths](dtMinusMonths.md)

[dtPlusDays](dtPlusDays.md)

[CompactSet](CompactSet.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
