## dtGetYear

Returns the year of the member parameter


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |



### Return

```
numeric-value
```



### Description

This functions returns the year.



### Since Version

6.2


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtGetYear(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the year.

**Query**

```
dtGetYear( [Calendar].[Day].[15 Jan 2016])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>2016</td></tr></table>


**Assertion : MDX Equals**

```
2016
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtGetYear(NULL) - return NULL

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the first parameter is NULL or an empty entity.

**Query**

```
dtGetYear( NULL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtGetYear(member) - member not a date time type

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error when the member is not a date/time.

**Query**

```
dtGetYear( [Geography].[Geo].[Paris])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_LEVEL_DATETIME_KEYTYPE_EXPECTED](icCubeError.md#olap_level_datetime_keytype_expected)</td></tr><tr><td>Error Message</td><td>

dtGetYear() : The level ('[Geography].[Geo].[City]') is expected with a date or date time key type (got :'String')</td></tr></table>


 
</div>

                                                                         

### See Also


[dtNextWeek](dtNextWeek.md)

[dtNextMonth](dtNextMonth.md)

[dtNextQuarter](dtNextQuarter.md)

[dtNextYear](dtNextYear.md)

[dtPreviousDay](dtPreviousDay.md)

[dtPreviousWeek](dtPreviousWeek.md)

[dtPreviousMonth](dtPreviousMonth.md)

[dtPreviousQuarter](dtPreviousQuarter.md)

[dtPreviousYear](dtPreviousYear.md)

[dtPlusDays](dtPlusDays.md)

[dtPlusWeeks](dtPlusWeeks.md)

[dtPlusMonths](dtPlusMonths.md)

[dtPlusQuarters](dtPlusQuarters.md)

[dtPlusYears](dtPlusYears.md)

[dtMinusDays](dtMinusDays.md)

[dtMinusWeeks](dtMinusWeeks.md)

[dtMinusMonths](dtMinusMonths.md)

[dtMinusQuarters](dtMinusQuarters.md)

[dtMinusYears](dtMinusYears.md)

[dtFirstDayOfWeekOfMonth](dtFirstDayOfWeekOfMonth.md)

[dtFirstDayOfWeekOfQuarter](dtFirstDayOfWeekOfQuarter.md)

[dtFirstDayOfWeekOfYear](dtFirstDayOfWeekOfYear.md)

[dtLastDayOfWeekOfMonth](dtLastDayOfWeekOfMonth.md)

[dtLastDayOfWeekOfQuarter](dtLastDayOfWeekOfQuarter.md)

[dtLastDayOfWeekOfYear](dtLastDayOfWeekOfYear.md)

[dtNthDayOfWeekOfMonth](dtNthDayOfWeekOfMonth.md)

[dtNthDayOfWeekOfQuarter](dtNthDayOfWeekOfQuarter.md)

[dtNthDayOfWeekOfYear](dtNthDayOfWeekOfYear.md)

[dtDatesWeek](dtDatesWeek.md)

[dtDatesWeekend](dtDatesWeekend.md)

[dtDatesWorkweek](dtDatesWorkweek.md)

[dtDatesWtd](dtDatesWtd.md)

[dtDatesMtd](dtDatesMtd.md)

[dtDatesQtd](dtDatesQtd.md)

[dtDatesYtd](dtDatesYtd.md)

[dtDatesItd](dtDatesItd.md)

[dtDatesWfd](dtDatesWfd.md)

[dtDatesMfd](dtDatesMfd.md)

[dtDatesQfd](dtDatesQfd.md)

[dtDatesYfd](dtDatesYfd.md)

[dtWithDayOfWeek](dtWithDayOfWeek.md)

[dtWithDayOfMonth](dtWithDayOfMonth.md)

[dtWithDayOfYear](dtWithDayOfYear.md)

[dtWithMonthOfYear](dtWithMonthOfYear.md)

[dtWithYear](dtWithYear.md)

[dtWithTime](dtWithTime.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
