## dtGetDayOfMonth

Returns the day of the month of the member parameter (1-31)


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |



### Return

```
numeric-value
```



### Description

This functions returns the day of the month.



### Since Version

6.2


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtGetDayOfMonth(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the day of the Month.

**Query**

```
dtGetDayOfMonth( [Calendar].[Day].[15 Jan 2016])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>15</td></tr></table>


**Assertion : MDX Equals**

```
15
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtGetDayOfMonth(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the day of the Month.

**Query**

```
dtGetDayOfMonth( [Calendar].[Day].[22 Feb 2016])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>22</td></tr></table>


**Assertion : MDX Equals**

```
22
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtGetDayOfMonth(NULL) - return NULL

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the first parameter is NULL or an empty entity.

**Query**

```
dtGetDayOfMonth( NULL )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtGetDayOfMonth(member) - member not a date time type

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error when the member is not a date/time.

**Query**

```
dtGetDayOfMonth( [Geography].[Geo].[Paris])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_LEVEL_DATETIME_KEYTYPE_EXPECTED](icCubeError.md#olap_level_datetime_keytype_expected)</td></tr><tr><td>Error Message</td><td>

dtGetDayOfMonth() : The level ('[Geography].[Geo].[City]') is expected with a date or date time key type (got :'String')</td></tr></table>


 
</div>

                                                                         

### See Also


[dtGetDayOfMonth](dtGetDayOfMonth.md)

[dtGetDayOfWeek](dtGetDayOfWeek.md)

[dtGetDayOfYear](dtGetDayOfYear.md)

[dtGetMonthOfYear](dtGetMonthOfYear.md)

[dtGetWeekOfYear](dtGetWeekOfYear.md)

[dtGetYear](dtGetYear.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
