## dtDatesMfd

Returns a set of members FROM the member parameter to the last day of the month.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |
|compactSet |boolean |zero-one |false |



### Return

```
set
```



### Description

This functions returns a set of members from the member parameter to the last day of the week.

dtMfd( [Time].[Calendar].[Day].[6 Jun 2006] ) will return all days from the 6th to the end of month.

If the compactSet parameter is set to true the set is compacted (most probably without any effect as the natural parent of a day it's the month)



### Since Version

6.0


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtDatesMfd(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a set will all members starting FROM the parameter member to the last day of the member's month.

**Query**

```
dtDatesMfd([Calendar].[Day].[28 Mar 2016])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Calendar].[Calendar].[Day].&[2016-03-28], 
  [Calendar].[Calendar].[Day].&[2016-03-29], 
  [Calendar].[Calendar].[Day].&[2016-03-30], 
  [Calendar].[Calendar].[Day].&[2016-03-31]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Calendar].[Day].[28 Mar 2016]:[Calendar].[Day].[31 Mar 2016]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtDatesMfd(member) - member a month level

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the member parameter if applied to a member of hierarchy level that is a month.

**Query**

```
dtDatesMfd([Calendar].[2016 Mar] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Calendar].[2016 Mar]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtDatesMfd(member) - member not a day level

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if applied to a member of hierarchy level that is above a month (e.g year).

**Query**

```
dtDatesMfd([Calendar].[Year].[2016] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtDatesMfd(NULL) - returns empty set

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if the member is NULL.

**Query**

```
dtDatesMfd(NULL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtDatesMfd(member) - member not a date time type

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to a hierarchy that is not a data time one.

**Query**

```
dtDatesMfd([Geography].[Geo].[Paris])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_LEVEL_DATETIME_KEYTYPE_EXPECTED](icCubeError.md#olap_level_datetime_keytype_expected)</td></tr><tr><td>Error Message</td><td>

dtDatesMfd() : The level ('[Geography].[Geo].[City]') is expected with a date or date time key type (got :'[STRING]')</td></tr></table>


 
</div>

                                                                         

### See Also


[CompactSet](CompactSet.md)

[dtAsOf](dtAsOf.md)

[dtAsOfToday](dtAsOfToday.md)

[dtNextDay](dtNextDay.md)

[dtNextWeek](dtNextWeek.md)

[dtNextMonth](dtNextMonth.md)

[dtNextQuarter](dtNextQuarter.md)

[dtNextYear](dtNextYear.md)

[dtPreviousDay](dtPreviousDay.md)

[dtPreviousWeek](dtPreviousWeek.md)

[dtPreviousMonth](dtPreviousMonth.md)

[dtPreviousQuarter](dtPreviousQuarter.md)

[dtPreviousYear](dtPreviousYear.md)

[dtPlusDays](dtPlusDays.md)

[dtPlusWeeks](dtPlusWeeks.md)

[dtPlusMonths](dtPlusMonths.md)

[dtPlusQuarters](dtPlusQuarters.md)

[dtPlusYears](dtPlusYears.md)

[dtMinusDays](dtMinusDays.md)

[dtMinusWeeks](dtMinusWeeks.md)

[dtMinusMonths](dtMinusMonths.md)

[dtMinusQuarters](dtMinusQuarters.md)

[dtMinusYears](dtMinusYears.md)

[dtFirstDayOfWeekOfMonth](dtFirstDayOfWeekOfMonth.md)

[dtFirstDayOfWeekOfQuarter](dtFirstDayOfWeekOfQuarter.md)

[dtFirstDayOfWeekOfYear](dtFirstDayOfWeekOfYear.md)

[dtLastDayOfWeekOfMonth](dtLastDayOfWeekOfMonth.md)

[dtLastDayOfWeekOfQuarter](dtLastDayOfWeekOfQuarter.md)

[dtLastDayOfWeekOfYear](dtLastDayOfWeekOfYear.md)

[dtNthDayOfWeekOfMonth](dtNthDayOfWeekOfMonth.md)

[dtNthDayOfWeekOfQuarter](dtNthDayOfWeekOfQuarter.md)

[dtNthDayOfWeekOfYear](dtNthDayOfWeekOfYear.md)

[dtDatesWeek](dtDatesWeek.md)

[dtDatesWeekend](dtDatesWeekend.md)

[dtDatesWorkweek](dtDatesWorkweek.md)

[dtDatesWtd](dtDatesWtd.md)

[dtDatesMtd](dtDatesMtd.md)

[dtDatesQtd](dtDatesQtd.md)

[dtDatesYtd](dtDatesYtd.md)

[dtDatesItd](dtDatesItd.md)

[dtDatesWfd](dtDatesWfd.md)

[dtDatesMfd](dtDatesMfd.md)

[dtDatesQfd](dtDatesQfd.md)

[dtDatesYfd](dtDatesYfd.md)

[dtWithDayOfWeek](dtWithDayOfWeek.md)

[dtWithDayOfMonth](dtWithDayOfMonth.md)

[dtWithDayOfYear](dtWithDayOfYear.md)

[dtWithMonthOfYear](dtWithMonthOfYear.md)

[dtWithYear](dtWithYear.md)

[dtWithTime](dtWithTime.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
