## NON_EMPTY_BEHAVIOR

Defines the non-empty behavior of a calculated measure.




### Description

A MDX identifier (or a set of MDX identifiers) referencing the measure group(s) or the measure(s) defining
the non-empty behavior of a calculated measure. It is used when processing non-empty statement. When specified,
icCube sets the calculated measure as empty if all the specified measures are empty.

This is handy to activate fast non-empty cross join calculations.

An example using a measure group:

`WITH MEMBER [Measures].[Amount*2] AS 2 * [Measures].[Amount], NON_EMPTY_BEHAVIOR = [default]`

An example using a measure:

`WITH MEMBER [Measures].[Amount*2] AS 2 * [Measures].[Amount], NON_EMPTY_BEHAVIOR = [Measures].[Amount]`

For multi-cube support, the cube name can be used to prefix the measure or measure group:

`WITH MEMBER [Measures].[Amount*2] AS 2 * [Measures].[Amount], NON_EMPTY_BEHAVIOR = [Sales].[default]`

The special identifier `[one$]` can be used to define the calculated member as non-empty always.

Note that icCube is able to determine automatically the `NON_EMPTY_BEHAVIOR` of a formula based on the actual
content of this formula. This logic is controlled via the `icCube.nonEmptyBehaviorSetupMode` property defined
in the `icCube.xml` file.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### on measures

</div>

<div class="ic3-mdx-example-body" style="display:none">

Two examples of defining NON_EMPTY_BEHAVIOR. The first one uses 'default' which is the measure group of the [Amount] measure. The second one uses directly the measure.

**Query**

```
WITH
    MEMBER [Measures].[Amount*2] AS 2 * [Measures].[Amount] , NON_EMPTY_BEHAVIOR=default
SELECT
    [Measures].[Amount*2] ON 0
    NON EMPTY [Geography].[Geo].members * [Product].[Prod].members on 1
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount*2</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">All Regions</td>
<td class="ic3-mdx-result-cell-header">Crazy Development</td>
 <td>2046</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">All Regions</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;icCube</td>
 <td>2046</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">All Regions</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>1824</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">All Regions</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td>192</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">All Regions</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td>30</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;America</td>
<td class="ic3-mdx-result-cell-header">Crazy Development</td>
 <td>1536</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;America</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;icCube</td>
 <td>1536</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;America</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>1536</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
<td class="ic3-mdx-result-cell-header">Crazy Development</td>
 <td>1536</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;icCube</td>
 <td>1536</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>1536</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;New York</td>
<td class="ic3-mdx-result-cell-header">Crazy Development</td>
 <td>1536</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;New York</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;icCube</td>
 <td>1536</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;New York</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>1536</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
<td class="ic3-mdx-result-cell-header">Crazy Development</td>
 <td>510</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;icCube</td>
 <td>510</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>288</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td>192</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td>30</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
<td class="ic3-mdx-result-cell-header">Crazy Development</td>
 <td>8</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;icCube</td>
 <td>8</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td>8</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Paris</td>
<td class="ic3-mdx-result-cell-header">Crazy Development</td>
 <td>8</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Paris</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;icCube</td>
 <td>8</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Paris</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td>8</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
<td class="ic3-mdx-result-cell-header">Crazy Development</td>
 <td>6</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;icCube</td>
 <td>6</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td>6</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Barcelona</td>
<td class="ic3-mdx-result-cell-header">Crazy Development</td>
 <td>4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Barcelona</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;icCube</td>
 <td>4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Barcelona</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td>4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Madrid</td>
<td class="ic3-mdx-result-cell-header">Crazy Development</td>
 <td>2</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Madrid</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;icCube</td>
 <td>2</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Madrid</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td>2</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
<td class="ic3-mdx-result-cell-header">Crazy Development</td>
 <td>496</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;icCube</td>
 <td>496</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>288</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td>192</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td>16</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Geneva</td>
<td class="ic3-mdx-result-cell-header">Crazy Development</td>
 <td>256</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Geneva</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;icCube</td>
 <td>256</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Geneva</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>256</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Lausanne</td>
<td class="ic3-mdx-result-cell-header">Crazy Development</td>
 <td>112</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Lausanne</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;icCube</td>
 <td>112</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Lausanne</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>32</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Lausanne</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td>64</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Lausanne</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td>16</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Zurich</td>
<td class="ic3-mdx-result-cell-header">Crazy Development</td>
 <td>128</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Zurich</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;icCube</td>
 <td>128</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Zurich</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td>128</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
   MEMBER [Measures].[Amount*2] AS 2 * [Measures].[Amount] , NON_EMPTY_BEHAVIOR=[Measures].[Amount]
SELECT
   [Measures].[Amount*2] ON 0
   NON EMPTY [Geography].[Geo].members * [Product].[Prod].members on 1
FROM
   [Sales]
```


 
</div>

                                                                                                            

### See Also


[Cell Properties](../Cell%20Properties.md)

[NonEmpty](../NonEmpty.md)

[NonEmptyX](../NonEmptyX.md)


### XMLA Properties

Find [here](../icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
