## CLASSNAME

Defines HML/CSS properties to be used for cell rendering.




### Description

The `CLASSNAME` cell property matches the corresponding CSS attributes and can take any valid CSS string.

This property is directly compatible with Google Visualization Table and icCube Pivot Table charts.

<pre>
MEMBER [MyMeasure] AS mdx-expression, CLASSNAME = 'warning-cell number-cell'
</pre>

Where `warning-cell` and `number-cell` are HTML/CSS classes.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CLASSNAME - conditional formatting

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example to be used as 'inspiration' for conditional formatting.

**Query**

```
WITH
    -- let's use an existing css class 'help-results'
    FUNCTION setCssClass(_value) AS IIF( _value > 10, 'help-cell-warning', 'help-cell-error' )
    MEMBER [Test] AS 1, CLASSNAME = setCssClass( currentCellValue() )
SELECT
    {[Test]} on 0
FROM sales
CELL PROPERTIES VALUE,CLASSNAME
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Test</td>
</tr>
<tr>
 <td class='help-cell-error'>1</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Test] AS 1, CLASSNAME="help-cell-error"
SELECT
    {[Test]} on 0
FROM sales
CELL PROPERTIES VALUE,CLASSNAME
```


 
</div>

                                                                                                            

### See Also


[Cell Properties](../Cell%20Properties.md)

[STYLE](STYLE.md)


### XMLA Properties

Find [here](../icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
