## CAPTION

Defines the caption of a calculated member.




### Description

Defines the caption of a calculated member.

To localize in place the caption you have to follow the pattern: `\default_caption[\locale:caption]*`.
For example: `CAPTION="\Good Morning\fr:Bonjour\es:Hola"`. The backslash character can be escaped with
a double backslash `\\`.

As an alternate solution, use the [schema localization](../../user_guide/schemas_cubes/localization.md) to define and localize the caption of any MDX entity.



### Since Version

8.3


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CAPTION = "..." 

</div>

<div class="ic3-mdx-example-body" style="display:none">

In this example, the caption of [X] is defined as "The Answer". Note that for calculated members defined at schema level the localization table can override this CAPTION for different locales. Note the usage of " when defining the new caption value.

**Query**

```
WITH
    MEMBER [X]         AS 42, CAPTION = "The Answer"
    MEMBER [X Name]    AS [X].Properties('NAME')
    MEMBER [X Caption] AS [X].Properties('CAPTION')
    MEMBER [X Caption II] AS [X].caption

SELECT { [X Name], [X Caption],[X Caption II] } ON 0 FROM SALES
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">X Name</td>
  <td class="ic3-mdx-result-cell-header">X Caption</td>
  <td class="ic3-mdx-result-cell-header">X Caption II</td>
</tr>
<tr>
 <td>X</td>
 <td>The Answer</td>
 <td>The Answer</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [X Name]    AS "X"
    MEMBER [X Caption] AS "The Answer"
    MEMBER [X Caption II] AS "The Answer"
SELECT { [X Name], [X Caption],[X Caption II] } ON 0 FROM SALES
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CAPTION (localized)

</div>

<div class="ic3-mdx-example-body" style="display:none">

In this example, run the test with French locale and use the French locale ('Bonjour')

**Query**

```
WITH
    MEMBER [X]         AS 42, CAPTION = "\Hola\fr:Bonjour"

SELECT { [X] } ON 0 FROM SALES
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Bonjour</td>
</tr>
<tr>
 <td>42</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Bonjour]    AS 42
SELECT { [Bonjour] } ON 0 FROM SALES
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CAPTION (localized default)

</div>

<div class="ic3-mdx-example-body" style="display:none">

In this example, use the default locale as defined ('Hola')

**Query**

```
WITH
    MEMBER [X]         AS 42, CAPTION = "\Hola\fr:Bonjour"

SELECT { [X] } ON 0 FROM SALES
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Hola</td>
</tr>
<tr>
 <td>42</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Hola]    AS 42
SELECT { [Hola] } ON 0 FROM SALES
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CAPTION (localized escaping)

</div>

<div class="ic3-mdx-example-body" style="display:none">

In this example, we escape the backslash character.

**Query**

```
WITH
    MEMBER [X]         AS 42, CAPTION = "\Hola\fr:Bonjour\\:toi"

SELECT { [X] } ON 0 FROM SALES
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Bonjour\:toi</td>
</tr>
<tr>
 <td>42</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Bonjour\:toi]    AS 42
SELECT { [Bonjour\:toi] } ON 0 FROM SALES
```


 
</div>

                                                                                                            

### See Also


[Cell Properties](../Cell%20Properties.md)

[LANGUAGE](LANGUAGE.md)

[Caption](../Caption.md)


### XMLA Properties

Find [here](../icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
