## VectorA

Returns a VectorA.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression |one | |
|value |numeric-expression |one | |
|limit |numeric-expression |zero-one | |
|flag |EXCLUDEEMPTY-INCLUDEEMPTY |zero-one |INCLUDEEMPTY |



### Return

```
value
```



### Description

This function is similar to Vector but returning a VectorA. This new structure holds not only the numerical Vector but also the information on the set/axis that generated it.

The VectorA can be used to put the result into a modified MDX statement (SELECT [my-vector] ON AXES..) that will return the matrix as a standard MDX statement with Column and Rows.

VectorA shares the same operations and scalar operators (+-*) as Vector.

See [VectorN](VectorN.md) for examples of available operations and this [page](../mdx_types/vector.md) for all the available functions.



### Since Version

4.8


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorA(set,scalar)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Standard example. VectorA as the Vector() function keeps by default the empty values (INCLUDEEMPTY option).

**Query**

```
WITH
  MEMBER [Measures].[vector-a] AS VectorA( [Geography].[Geo].[Country], [Measures].[Amount] )
SELECT
  [Measures].[vector-a] on Axes
FROM
  [Sales]
WHERE
  [Geography].[Geo].[Switzerland]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">vector-a</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td>0.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td>0.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>768.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Venezuela</td>
 <td>0.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>4.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>3.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>248.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[asDouble] AS [Measures].[Amount] + 0.0
SELECT
    [Measures].[asDouble] on 0,
    [Geography].[Geo].[Country] on 1
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[vector-a] AS VectorA( [Geography].[Geo].[Country], [Measures].[Amount], INCLUDEEMPTY )
SELECT
  [Measures].[vector-a] on Axes
FROM
  [Sales]
WHERE
  [Geography].[Geo].[Switzerland]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorA(set,scalar,EXCLUDEEMPTY)

</div>

<div class="ic3-mdx-example-body" style="display:none">

As for the Vector() function you can use the EXCLUDEEMPTY option to remove empty tuples from the set.

**Query**

```
WITH
  MEMBER [Measures].[vector-a] AS VectorA( [Geography].[Geo].[Country], [Measures].[Amount], EXCLUDEEMPTY )
SELECT
  [Measures].[vector-a] on Axes
FROM
  [Sales]
WHERE
  [Geography].[Geo].[Switzerland]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">vector-a</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>768.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>4.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>3.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>248.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[asDouble] AS [Measures].[Amount] + 0.0
SELECT
    [Measures].[asDouble] on 0,
    nonempty([Geography].[Geo].[Country], [Amount] ) on 1
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorA( Unorder(set),scalar,EXCLUDEEMPTY) - Unorder / Faster

</div>

<div class="ic3-mdx-example-body" style="display:none">

Adding Unorder to the set will allow for faster parallel processing (if active) mostly with he EXCLUDEEMPTY flag active. Pay attention there is no guarantee on the order of the set items.

**Query**

```
WITH
  MEMBER [Measures].[vector-a] AS VectorA( Unorder([Geography].[Geo].[Country]), [Measures].[Amount], EXCLUDEEMPTY )
SELECT
  [Measures].[vector-a] on Axes
FROM
  [Sales]
WHERE
  [Geography].[Geo].[Switzerland]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">vector-a</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>768.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>4.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>3.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>248.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[asDouble] AS [Measures].[Amount] + 0.0
SELECT
    [Measures].[asDouble] on 0,
    nonempty([Geography].[Geo].[Country], [Amount] ) on 1
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorA(set,scalar) - CELL PROPERTIES

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example that show how MDX properties are calculated also for each element of the vector.

**Query**

```
WITH
  MEMBER [Measures].[vector-a] AS VectorA( [Geography].[Geo].[Country], [Measures].[Amount] ),
            FORMAT_STRING = IIF( currentCellValue() <> 0.0, "j:%,3.2f", "j:-")

SELECT
  [Measures].[vector-a] on Axes
FROM
  [Sales]
WHERE
  [Geography].[Geo].[Switzerland]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">vector-a</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td>-</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td>-</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>768.00</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Venezuela</td>
 <td>-</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>4.00</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>3.00</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>248.00</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[vector-a-element] AS [Measures].[Amount] + 0.0 /* EMPTY + 0.0 = 0.0 */,
              FORMAT_STRING = IIF( currentCellValue() <> 0.0, "j:%,3.2f", "j:-")
SELECT
    [Measures].[vector-a-element] on 0,
    [Geography].[Geo].[Country] on 1
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[Vector](Vector.md)

[VectorK](VectorK.md)

[VectorN](VectorN.md)

[VectorS](VectorS.md)

[ElementValue](ElementValue.md)

[SetAxes](SetAxes.md)

[MatrixA](MatrixA.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
