## Vector

Returns a Vector of numerical values.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression |one | |
|value |numeric-expression |one | |
|limit |numeric-expression |zero-one | |
|flag |EXCLUDEEMPTY-INCLUDEEMPTY |zero-one |INCLUDEEMPTY |



### Return

```
value
```



### Description

This function creates a vector object of numerical values (double). Different syntax might be used :

<pre>
- Vector( [Geography].[Country].members, [Measures].[Amount])
- Vector( [Geography].[Country].members, [Measures].[Amount],3) , ensures vector is not larger than 3
</pre>

Once the vector is created, you can call perform various operations on it :

<pre>
Vector(..)->max()
Vector(..)->min()
</pre>

See [VectorN](VectorN.md) for examples of available operations and this [page](../mdx_types/vector.md) for all the available operations.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Vector(Set,Expression)

</div>

<div class="ic3-mdx-example-body" style="display:none">

A vector can be created as a numerical MDX expression applied to a set of tuples.

In this example, sales amount for all countries (the multiplication by 1.0 is here to convert the integer to a double value).

**Query**

```
WITH
    MEMBER [Measures].[val] AS Vector( [Geography].[Geo].[Country].members, [Measures].[Amount] ) -> sum()
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>1023.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS sum( [Geography].[Geo].[Country].members, 1.0 * [Measures].[Amount] )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Vector(set,scalar,EXCLUDEEMPTY)

</div>

<div class="ic3-mdx-example-body" style="display:none">

You can use the EXCLUDEEMPTY option to remove empty tuples from the set.

**Query**

```
WITH
    MEMBER [Measures].[val] AS Vector( [Geography].[Geo].[Country].members, [Measures].[Amount],EXCLUDEEMPTY ) -> sum()
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>1023.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS sum( [Geography].[Geo].[Country].members, 1.0 * [Measures].[Amount] )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Vector( Unorder(set),scalar,EXCLUDEEMPTY) - Unorder / Faster

</div>

<div class="ic3-mdx-example-body" style="display:none">

Adding Unorder to the set will allow for faster parallel processing (if active) mostly with he EXCLUDEEMPTY flag active. Pay attention there is no guarantee on the order of the set items.

**Query**

```
WITH
    MEMBER [Measures].[val] AS Vector(  UnOrder([Geography].[Geo].[Country].members), [Measures].[Amount],EXCLUDEEMPTY ) -> sum()
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>1023.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS sum( [Geography].[Geo].[Country].members, 1.0 * [Measures].[Amount] )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Vector(Set,Expression, limit)

</div>

<div class="ic3-mdx-example-body" style="display:none">

A vector can be created with a length, size, limit.

In this example, we take the first 7 values.

**Query**

```
WITH
    MEMBER [Measures].[val] AS Vector( [Geography].[Geo].[Country].members, [Measures].[Amount],7 ) -> length()
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>7</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS 7
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS Vector( [Geography].[Geo].[Country].members, [Measures].[Amount],7,INCLUDEEMPTY ) -> length()
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[VectorA](VectorA.md)

[VectorK](VectorK.md)

[VectorN](VectorN.md)

[VectorS](VectorS.md)

[Matrix](Matrix.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
