## UnknownMembers

Returns the unknown members of the specified dimension or hierarchy.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |dimension-hierarchy-expression |one | |



### Return

```
member
```



### Description

Returns the unknown members of the specified dimension or hierarchy. Remember we might have one unknown member
defined per level of the hierarchy.

Returns an empty set if the hierarchy has no unknown members.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### UnknownMembers(Hierarchy)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the unknown members of the [Calendar] hierarchy.

**Query**

```
UnknownMembers([Time].[Calendar])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Filter( [Time].[Calendar].members as t, isUnknown(t) )
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### UnknownMembers(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to a member.

**Query**

```
[Time].[Calendar].[2010].UnknownMembers
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

UnknownMembers() : argument (0) type mismatch: expected:'hierarchy|dimension', got:'member'</td></tr></table>


 
</div>

                                                                         

### See Also


[IsUnknown](IsUnknown.md)

[CurrentMember](CurrentMember.md)

[DefaultMember](DefaultMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
