## Union

Returns a set generated by the union of a list of sets, optionally retaining duplicate members.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one-n | |
| |ALL |zero-one | |



### Return

```
set
```



### Description

Returns a set generated by the union of a list of sets. This function is equivalent to the
+ operator: Union(A,B) = A + B.

By default, duplicated members (or tuples) are removed from the union. The ALL option allows for keeping those duplicated elements.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Union(member-set,member-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the union of the specified member sets.

**Query**

```
UNION(
    {[Geography].[Geo].[United States]},
    {[Geography].[Geo].[Switzerland]}
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[United States], 
  [Geography].[Geo].[Country].[Switzerland]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[United States]} + {[Geography].[Geo].[Switzerland]}
```


**Assertion : MDX Equals**

```
{[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Union(tuple-set,tuple-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the union of the specified member sets.

**Query**

```
UNION(
    {([Product].[Prod].[Corporate],[Geography].[Geo].[Spain])},
    {([Product].[Prod].[Corporate],[Geography].[Geo].[Switzerland])}
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Product].[Prod].[Licence].[Corporate], [Geography].[Geo].[Country].[Spain] ), 
  ( [Product].[Prod].[Licence].[Corporate], [Geography].[Geo].[Country].[Switzerland] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{([Product].[Prod].[Corporate],[Geography].[Geo].[Spain])}
+
{([Product].[Prod].[Corporate],[Geography].[Geo].[Switzerland])}
```


**Assertion : MDX Equals**

```
[Product].[Prod].[Corporate] * {[Geography].[Geo].[Spain],[Geography].[Geo].[Switzerland]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Union(member-set,member-set)- remove duplicates

</div>

<div class="ic3-mdx-example-body" style="display:none">

Union, as well as the + operator, will remove duplicated elements from resulting set.

**Query**

```
UNION(
    {[Geography].[Geo].[Spain],[Geography].[Geo].[Switzerland]},
    {[Geography].[Geo].[Spain]}
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[Country].[Switzerland]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Spain],[Geography].[Geo].[Switzerland]}
```


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Spain],[Geography].[Geo].[Switzerland]} +
{[Geography].[Geo].[Spain]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Union(member-set,member-set,ALL)- keep duplicated

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using the ALL parameter will return the union of the sets including duplicates.

**Query**

```
Union(
    {[Geography].[Geo].[Spain],[Geography].[Geo].[Switzerland]},
    {[Geography].[Geo].[Spain]},ALL
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[Country].[Switzerland], 
  [Geography].[Geo].[Country].[Spain]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Spain],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Union(member-set,member-set,member-set) - variable number of sets

</div>

<div class="ic3-mdx-example-body" style="display:none">

Union function can add a variable number of sets; in our example three sets.

**Query**

```
Union(
    {[Geography].[Geo].[Spain]},
    {[Geography].[Geo].[Switzerland]},
    {[Geography].[Geo].[United States],[Geography].[Geo].[France]},
ALL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[Country].[Switzerland], 
  [Geography].[Geo].[Country].[United States], 
  [Geography].[Geo].[Country].[France]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Spain],[Geography].[Geo].[Switzerland],
[Geography].[Geo].[United States],[Geography].[Geo].[France]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Union(member-set,member-set) - different dimensionality

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to set of different dimensionality, members of both set are not of the same hierarchy.

**Query**

```
UNION( [Geography].[Geo].members, [Geography].[Economy] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_INVALID_TUPLE_DIMENSIONALITY](icCubeError.md#olap_invalid_tuple_dimensionality)</td></tr><tr><td>Error Message</td><td>

invalid tuple dimensionality '[Geography].[Geo]' - '[Geography].[Economy]'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Union(tuple-set,tuple-set) - different dimensionality

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to set of different dimensionality, there is a mismatch on tuples hierarchies.

**Query**

```
UNION(
    { ( [Geography].[Geo].[Spain], [Time].[Calendar].[2010]  ) },
    { ( [Time].[Calendar].[2010] , [Geography].[Geo].[Spain] ) }
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_INVALID_TUPLE_DIMENSIONALITY](icCubeError.md#olap_invalid_tuple_dimensionality)</td></tr><tr><td>Error Message</td><td>

invalid tuple dimensionality '[Geography].[Geo],[Time].[Calendar]' - '[Time].[Calendar],[Geography].[Geo]'</td></tr></table>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Union(member-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to a single set.

**Query**

```
UNION( { [Geography].[Geo].[Paris] } )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_UNEXPECTED_SET_COUNT](icCubeError.md#olap_unexpected_set_count)</td></tr><tr><td>Error Message</td><td>

Union() : the function is expecting at least two sets</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Union({},{}), Union(NULL,NULL), Union({},NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if applied to an empty set or NULL entities.

**Query**

```
{}
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : Cell Equals**

```
UNION({},{})
```


**Assertion : Cell Equals**

```
UNION(null,null)
```


**Assertion : Cell Equals**

```
UNION({},null)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Union(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
UNION("hello",{})
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Union() : argument (0) type mismatch: expected:'set', got:'string'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Union(member-set,member-set,INVALID_FLAG)

</div>

<div class="ic3-mdx-example-body" style="display:none">

An invalid flag generates an error.

**Query**

```
UNION( {}, {}, INVALID_FLAG)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_UNKNOWN_DIMENSION_HIERARCHY](icCubeError.md#olap_unknown_dimension_hierarchy)</td></tr><tr><td>Error Message</td><td>

'INVALID_FLAG' is neither a dimension nor a hierarchy within the cube.</td></tr></table>


 
</div>

                                                                         

### See Also


[Except](Except.md)

[Intersect](Intersect.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
