## TupleToStr

Converts a tuple into a string of its member unique names.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |tuple-expression | | |



### Return

```
string
```



### Description

Returns a string of unique names of the members of the specified tuple.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TupleToStr(tuple)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a string the the tuple using unique names.

**Query**

```
WITH
    MEMBER [Measures].[V] AS TupleToStr( ( [Geography].[Geo].[Zurich],[Product].[Prod].[icCube] ) )
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">V</td>
</tr>
<tr>
 <td>([Geography].[Geo].[City].&[ZURICH],[Product].[Prod].[Article].&[ICCUBE])</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[V] AS "(" + [Geography].[Geo].[Europe].[Switzerland].[Zurich].UNIQUE_NAME + "," + [Product].[Prod].[Crazy Development].[icCube].UNIQUE_NAME + ")"
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TupleToStr(level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
    MEMBER [Measures].[XXX] AS TupleToStr([Geography].[Geo].[Continent])
SELECT
    [Measures].[XXX] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">XXX</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : TupleToStr() : argument (0) type mismatch: expected:'tuple', got:'level'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TupleToStr(memberSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
    MEMBER [Measures].[XXX] AS TupleToStr({[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]})
SELECT
    [Measures].[XXX] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">XXX</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : TupleToStr() : argument (0) type mismatch: expected:'tuple', got:'set'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TupleToStr(tupleSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
    MEMBER [Measures].[XXX] AS TupleToStr({([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])})
SELECT
    [Measures].[XXX] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">XXX</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : TupleToStr() : argument (0) type mismatch: expected:'tuple', got:'set'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TupleToStr(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
    MEMBER [Measures].[XXX] AS TupleToStr("hello")
SELECT
    [Measures].[XXX] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">XXX</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : TupleToStr() : argument (0) type mismatch: expected:'tuple', got:'string'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TupleToStr(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if applied to a NULL entity.

**Query**

```
WITH
    MEMBER [Measures].[XXX] AS TupleToStr( NULL ) = NULL
SELECT
    [Measures].[XXX] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">XXX</td>
</tr>
<tr>
 <td>false</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[XXX] AS FALSE
SELECT
    [Measures].[XXX] ON 0
FROM
    [Sales]
```


 
</div>

                                                                         

### See Also


[MemberToStr](MemberToStr.md)

[SetToStr](SetToStr.md)

[StrToTuple](StrToTuple.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
