## TopSum

Returns a sorted set (descending order) which member's values cumulative sum is greater or equal than the specified sum value.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression |one | |
|sum |numeric-expression |one | |
|measure |value-expression |one | |
|flag |EXCLUDEEMPTY-INCLUDEEMPTY |zero-one |INCLUDEEMPTY |



### Return

```
set
```



### Description

Function sorts the set in the descending order according to the specified measure and returns the minimum number of elements whose cumulative sum is greater or equal to the specified sum.

If 0 was specified as a value the member with the highest value for measure is returned.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopSum(set,sum,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a descending sorted set which cumulative sum is greater or equal than the specified 'sum' value.

In our example we return the two members [3],[2] as their value meets the requested 5 value and one member less would not be enough to reach 5.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[2]     AS 2.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
SELECT
    TopSum( {[Geography].[Geo].[1],[Geography].[Geo].[2],[Geography].[Geo].[3]},5, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">3</td>
  <td class="ic3-mdx-result-cell-header">2</td>
</tr>
<tr>
 <td>3.0</td>
 <td>2.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Geography].[Geo].[2]     AS 2.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
SELECT
   {[Geography].[Geo].[3],[Geography].[Geo].[2]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopSum(member-set,number,measure) - sum is too large

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the specified sum is greater than the total sum then all members will be returned.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[2]     AS 2.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
SELECT
    TopSum( {[Geography].[Geo].[1],[Geography].[Geo].[2],[Geography].[Geo].[3]}, 100, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">3</td>
  <td class="ic3-mdx-result-cell-header">2</td>
  <td class="ic3-mdx-result-cell-header">1</td>
</tr>
<tr>
 <td>3.0</td>
 <td>2.0</td>
 <td>1.0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[2]     AS 2.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
SELECT
    {[Geography].[Geo].[3],[Geography].[Geo].[2],[Geography].[Geo].[1]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopSum(member-set,0,measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

This function returns at least one member even though its value is greater than the parameter.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[2]     AS 2.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
SELECT
    TopSum( {[Geography].[Geo].[1],[Geography].[Geo].[2],[Geography].[Geo].[3]}, 0, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">3</td>
</tr>
<tr>
 <td>3.0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[3]     AS 3.0
SELECT
    {[Geography].[Geo].[3]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopSum(set,sum,numeric) - duplicated members

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
WITH
    MEMBER [Geography].[Geo].[1] AS 1.0
    MEMBER [Geography].[Geo].[2] AS 2.0
SELECT
    TopSum( { [Geography].[Geo].[2], [Geography].[Geo].[1], [Geography].[Geo].[2] }, 4, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">2</td>
  <td class="ic3-mdx-result-cell-header">2</td>
</tr>
<tr>
 <td>2.0</td>
 <td>2.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Geography].[Geo].[2]AS 2.0
SELECT
   { [Geography].[Geo].[2], [Geography].[Geo].[2] } ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopSum(member-set,-1,measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if a negative 'sum' value is specified.

**Query**

```
TopSum([Geography].[Geo].[City].Members, -1, [Measures].[Amount])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_OUT_OF_RANGE](icCubeError.md#olap_out_of_range)</td></tr><tr><td>Error Message</td><td>

TopSum() : the sum value '-1.0' is out of range (expected range:'>= 0')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopSum(member-set,1) - missing numeric expression

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if no numeric expression is specified.

**Query**

```
TopSum([Geography].[Geo].[City].Members, 1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_UNEXPECTED_ARGUMENT_COUNT](icCubeError.md#olap_function_unexpected_argument_count)</td></tr><tr><td>Error Message</td><td>

TopSum() : unexpected number of parameters '2' (expected:'4,3')</td></tr></table>


 
</div>

                                                                         

### See Also


[TopCount](TopCount.md)

[TopPercent](TopPercent.md)

[BottomSum](BottomSum.md)

[BottomCount](BottomCount.md)

[BottomPercent](BottomPercent.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
