## TopPercent

Returns a sorted (descending order) set which cumulative percent is greater or equal than the specified percent (i.e., a value between 0 and 100).


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression |one | |
|percent |numeric-expression |one | |
|measure |value-expression |one | |
|flag |EXCLUDEEMPTY-INCLUDEEMPTY |zero-one |INCLUDEEMPTY |



### Return

```
set
```



### Description

The function sorts the set in descending order according to the specified measure and returns the minimum number of elements whose cumulative percent is greater or equal to the specified percent.

If 0 was specified as a percent the member with the highest value is returned.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopPercent(member-set,numeric,measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a descending sorted set which cumulative percent is greater or equal than the specified 'percent' value.

In our example we return two members [50],[30] as their value meets the requested 55% of the total and with one member less would not be enough to reach 55%.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[20]     AS 20
    MEMBER [Geography].[Geo].[30]     AS 30
    MEMBER [Geography].[Geo].[50]     AS 50
SELECT
    TopPercent( {[Geography].[Geo].[20],[Geography].[Geo].[30],[Geography].[Geo].[50]},55, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">50</td>
  <td class="ic3-mdx-result-cell-header">30</td>
</tr>
<tr>
 <td>50</td>
 <td>30</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[30]     AS 30
    MEMBER [Geography].[Geo].[50]     AS 50
SELECT
    {[Geography].[Geo].[50],[Geography].[Geo].[30]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopPercent(member-set,numeric,measure) - duplicated members

</div>

<div class="ic3-mdx-example-body" style="display:none">

TopPercent makes no difference with duplicated members. Our example is selecting twice the [Geography].[Geo].[40] calculated member.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[40] AS 40
    MEMBER [Geography].[Geo].[20] AS 20
SELECT
    TopPercent( { [Geography].[Geo].[40], [Geography].[Geo].[20], [Geography].[Geo].[40] }, 80, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">40</td>
  <td class="ic3-mdx-result-cell-header">40</td>
</tr>
<tr>
 <td>40</td>
 <td>40</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[40] AS 40
SELECT
    { [Geography].[Geo].[40], [Geography].[Geo].[40] } ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopPercent(member-set,percent,numeric) - percent > 100 and empty values

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the specified 'percent' value is greater or equal than 100% all members will be returned, including empty cells.

In this case, the function behaves as Order(set,numeric2,BDESC) function.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[E]      AS NULL
    MEMBER [Geography].[Geo].[20]     AS 20
    MEMBER [Geography].[Geo].[30]     AS 30
    MEMBER [Geography].[Geo].[50]     AS 50
SELECT
    TopPercent( {[Geography].[Geo].[E],[Geography].[Geo].[20],[Geography].[Geo].[30],[Geography].[Geo].[50]},200, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">50</td>
  <td class="ic3-mdx-result-cell-header">30</td>
  <td class="ic3-mdx-result-cell-header">20</td>
  <td class="ic3-mdx-result-cell-header">E</td>
</tr>
<tr>
 <td>50</td>
 <td>30</td>
 <td>20</td>
 <td></td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[E]      AS NULL
    MEMBER [Geography].[Geo].[20]     AS 20
    MEMBER [Geography].[Geo].[30]     AS 30
    MEMBER [Geography].[Geo].[50]     AS 50
SELECT
     Order({[Geography].[Geo].[E],[Geography].[Geo].[20],[Geography].[Geo].[30],[Geography].[Geo].[50]}, [Measures].[Amount], BDESC)  ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopPercent(set,percent,numeric) - percent equals 0

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the specified 'percent' value is equal to 0 the first element of the set is returned (highest one).

**Query**

```
WITH
    MEMBER [Geography].[Geo].[20]     AS 20
    MEMBER [Geography].[Geo].[30]     AS 30
    MEMBER [Geography].[Geo].[50]     AS 50
SELECT
    TopPercent( {[Geography].[Geo].[20],[Geography].[Geo].[30],[Geography].[Geo].[50]},0, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">50</td>
</tr>
<tr>
 <td>50</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[50] AS 50
SELECT
    [Geography].[Geo].[50] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopPercent(set,percent,numeric) - negative percent

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if a negative 'percent' value is used.

**Query**

```
TopPercent([Geography].[Geo].[City].Members, -1, [Measures].[Amount])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_OUT_OF_RANGE](icCubeError.md#olap_out_of_range)</td></tr><tr><td>Error Message</td><td>

TopPercent() : the percent value '-1.0' is out of range (expected range:'[0..1]')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopPercent(member-set,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if a negative 'percent' value is used.

**Query**

```
TopPercent([Geography].[Geo].[City].Members, 1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_UNEXPECTED_ARGUMENT_COUNT](icCubeError.md#olap_function_unexpected_argument_count)</td></tr><tr><td>Error Message</td><td>

TopPercent() : unexpected number of parameters '2' (expected:'4,3')</td></tr></table>


 
</div>

                                                                         

### See Also


[TopCount](TopCount.md)

[TopSum](TopSum.md)

[BottomPercent](BottomPercent.md)

[BottomCount](BottomCount.md)

[BottomSum](BottomSum.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
