## Tail

Returns the last specified number of elements in a set.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |numeric-expression |zero-one |1 |



### Return

```
set
```



### Description

Returns a set containing the specified number of the elements from the end of the specified set.

If no numeric expression is specified the last element of the set will be returned.

If the specified number of elements is less than 1, an empty set will be returned.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Tail(set,count)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the last count items of the set.

In our example, returns the 2 last members of the set.

**Query**

```
Tail( [Geography].[Geo].[Continent].Members, 2 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{
    [Geography].[Geo].[Continent].Members( Count( [Geography].[Geo].[Continent].Members ) -2 ),
    [Geography].[Geo].[Continent].Members( Count( [Geography].[Geo].[Continent].Members ) -1 )
}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Tail(set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

If count is not specified the last item of the set is returned.

**Query**

```
Tail( [Geography].[Geo].[Continent].Members )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Continent].Members( Count( [Geography].[Geo].[Continent].Members ) -1 )
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Tail(member-set,0)

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the count is zero an empty set is returned

**Query**

```
Tail([Geography].[Geo].[Continent].Members,0)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Tail(set,count) - numeric too large

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the number of elements requested is bigger than the elements in the set, the original set is returned.

**Query**

```
Tail([Geography].[Geo].[Continent].Members,300000000)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Continent].Members}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Tail(set,count) - negative count

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if a negative count is specified.

**Query**

```
Tail([Geography].[Geo].[Continent].Members,-1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Tail({},numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if an empty set is specified.

**Query**

```
Tail({},0)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

                                                                         

### See Also


[Head](Head.md)

[Subset](Subset.md)

[Range](Range.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
