## SumOn

Returns the sum of each value of the first vector defined by the second vector positions.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |vector-expression |one | |
| |vector-expression |one | |



### Return

```
value
```



### Description

Returns the sum of each value of the first vector defined by the second vector positions.

SumOn ( V1, V2 ) = ForEach( V2i -> V2 ; sum += V1( V2i ) )

A standard scenario for this function is defining V1 as a static function that contains the values we want to
aggregate and V2 as a measure with a vector unique aggregation type.



### Since Version

6.0.3


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SumOn(V1, V2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the SumOn

**Query**

```
WITH
    MEMBER [Measures].[V1] AS VectorN( 1, 2, 4, 8, 16, 32 )
    MEMBER [Measures].[V2] AS VectorN( 0, 1, 5)
    MEMBER [Measures].[Sum Amount] AS SumOn( [V1], [V2] )
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Sum Amount</td>
</tr>
<tr>
 <td>35.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Sum Amount] AS 1.0+2+32
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SumOn(V1, V2) - out of bounds

</div>

<div class="ic3-mdx-example-body" style="display:none">

Positions defined by V2 that are out of bounds will be ignored.

**Query**

```
WITH
    MEMBER [Measures].[V1] AS VectorN( 1, 2, 4, 8, 16, 32 )
    MEMBER [Measures].[V2] AS VectorN( 0, 1, 5, 50, -50)
    MEMBER [Measures].[Sum Amount] AS SumOn( [V1], [V2] )
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Sum Amount</td>
</tr>
<tr>
 <td>35.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Sum Amount] AS 1.0+2+32
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SumON(NULL,NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if applied to a NULL entity.

**Query**

```
WITH
    MEMBER [Measures].[Sum Amount] AS SumOn(NULL,NULL)
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Sum Amount</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Sum Amount] AS null
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```


 
</div>

                                                                         

### See Also


[VectorK](VectorK.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
