## SubSelectAxis

Returns the set of tuples on a specified axis of the sub-select.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|axis-number |numeric-expression | | |



### Return

```
set
```



### Description

The axis-number is zero-based : axis(0) returns the columns axis, axis(1) returns the rows axis, and so on.



### Since Version

5.1.1


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Calculated Member

</div>

<div class="ic3-mdx-example-body" style="display:none">

In our example, we're displaying the name of the members in the sub-select.

**Query**

```
with
    member [Measures].[SubSelect] as Generate( SubSelectAxis(0) as yy, yy.currentMember(0).name, " - " )

select

    { [Measures].[SubSelect], [Measures].[Amount] } on 0,
    [Geography].[Geo].[Country].members on 1

from ( select { [Time].[Calendar].[2010], [Time].[Calendar].[2011] } on 0 from [Sales] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">SubSelect</td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td>2010 - 2011</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td>2010 - 2011</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>2010 - 2011</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Venezuela</td>
 <td>2010 - 2011</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>2010 - 2011</td>
 <td>4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>2010 - 2011</td>
 <td>3</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>2010 - 2011</td>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
with
    member [Measures].[SubSelect] as "2010 - 2011"

select

    { [Measures].[SubSelect], [Measures].[Amount] } on 0,
    [Geography].[Geo].[Country].members on 1

from ( select { [Time].[Calendar].[2010], [Time].[Calendar].[2011] } on 0 from [Sales] )
```


 
</div>

                                                                                                            

### See Also


[Axis](Axis.md)

[GetFilterInfo](GetFilterInfo.md)

[Slicer](Slicer.md)

[ContextMember](ContextMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
