## SubQueries

MDX subQueries (aka. subSelect).




### Description

SubQueries (or subSelects) allow for querying an MDX query instead of a cube.

As opposed to the `WHERE` clause, subQueries also change the hierarchies structure. Hierarchies defined in a subQuery are filtered (accepting all descendants and ascendants members defined in the subQuery).

See example `SubQueries in Axis - Branch` for more information.

<pre>
SELECT
    [Measures].members ON 0
FROM NON VISUAL ( SELECT [Geography].[Switzerland] ON 0 FROM [SALES] )
</pre>

The `NON VISUAL` flags control whether aggregation is using all members `NON VISUAL` or only the filtered members.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubQueries in Axis

</div>

<div class="ic3-mdx-example-body" style="display:none">

SubQueries are filtering all member related functions defined in the axis of an MDX query.

In our example, [Geography].[Geo].[Europe].children is returning only the sub-select
member [Geography].[Geo].[Switzerland].

**Query**

```
SELECT
    crossjoin([Geography].[Geo].[Europe].children,[Product].[Prod].[Personal]) ON 0
FROM
    ( SELECT [Geography].[Geo].[Switzerland] ON 0 FROM [Sales] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">Personal</td>
</tr>
<tr>
 <td>8</td>
</tr>
</table>



**Assertion : MDX Visual Equals**

```
SELECT
    {[Geography].[Geo].[Switzerland]}*{[Product].[Prod].[Personal]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubQueries in Axis - Branch

</div>

<div class="ic3-mdx-example-body" style="display:none">

Here is an example defining a single member in a subQuery; this will filter all its ascendants and descendants.

In our example, with [Switzerland] in the subQuery, the filter will return its children { [Lausanne],[Geneva]...} and all its ascendants { [Europe] }.

**Query**

```
SELECT
    Hierarchize( [Geography].[Geo].members ) ON 0
FROM
    ( SELECT [Geography].[Geo].[Switzerland] ON 0 FROM [Sales] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">All Regions</td>
  <td class="ic3-mdx-result-cell-header">Europe</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
  <td class="ic3-mdx-result-cell-header">Geneva</td>
  <td class="ic3-mdx-result-cell-header">Lausanne</td>
  <td class="ic3-mdx-result-cell-header">Zurich</td>
</tr>
<tr>
 <td>248</td>
 <td>248</td>
 <td>248</td>
 <td>128</td>
 <td>56</td>
 <td>64</td>
</tr>
</table>



**Assertion : MDX Visual Equals**

```
SELECT
    VisualTotals(Hierarchize(Ascendants([Geography].[Geo].[Switzerland]) + Descendants([Geography].[Geo].[Switzerland]) )) ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubQueries in Axis - Tuples

</div>

<div class="ic3-mdx-example-body" style="display:none">

SubQueries are also working with tuples. All non defined tuples in the sub-select are filtered in the axis.

**Query**

```
SELECT
    Hierarchize(crossjoin([Geography].[Geo].[Europe].children,[Product].[Prod].[icCube].children)) ON 0
FROM
    ( SELECT {([Geography].[Geo].[Switzerland],[Product].[Prod].[Personal]),([Geography].[Geo].[Spain],[Product].[Prod].[Partnership])} ON 0 FROM [Sales] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">Partnership</td>
  <td class="ic3-mdx-result-cell-header">Personal</td>
</tr>
<tr>
 <td></td>
 <td>8</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    Hierarchize({([Geography].[Geo].[Switzerland],[Product].[Prod].[Personal]),([Geography].[Geo].[Spain],[Product].[Prod].[Partnership])}) ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Sub-SubQueries and multiple axis

</div>

<div class="ic3-mdx-example-body" style="display:none">

SubQueries can be defined with more than one axis; this has the same behaviour as chained subQueries.

How does it work?

Each axis of the subQuery defines a filter, resulting in a list of filters. Filters are then applied recursively.

**Query**

```
SELECT
    crossjoin([Geography].[Geo].[Europe].children,[Product].[Prod].[icCube].children) ON 0
FROM
    ( SELECT [Geography].[Geo].[Switzerland] ON 0, [Product].[Prod].[Personal] ON 1 FROM [Sales] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">Personal</td>
</tr>
<tr>
 <td>8</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    {([Geography].[Geo].[Switzerland],[Product].[Prod].[Personal])} ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
SELECT
    crossjoin([Geography].[Geo].[Europe].children,[Product].[Prod].[icCube].children) ON 0
FROM
    ( SELECT [Geography].[Geo].[Switzerland] ON 0 FROM ( SELECT [Product].[Prod].[Personal] ON 0 FROM [Sales] ))
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Embedded Sub-SubQueries

</div>

<div class="ic3-mdx-example-body" style="display:none">

SubQueries can be chained, this has the same behaviour as a subQuery with multiple axis.

How does it work?

Each subQuery defines a filter, resulting in a list of filters. Filters are then applied recursively.

**Query**

```
SELECT
    crossjoin([Geography].[Geo].[Europe].children,[Product].[Prod].[icCube].children) ON 0
FROM
    ( SELECT [Geography].[Geo].[Switzerland] ON 0 FROM ( SELECT [Product].[Prod].[Personal] ON 0 FROM [Sales] ))
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">Personal</td>
</tr>
<tr>
 <td>8</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    {([Geography].[Geo].[Switzerland],[Product].[Prod].[Personal])} ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
SELECT
    crossjoin([Geography].[Geo].[Europe].children,[Product].[Prod].[icCube].children) ON 0
FROM
    ( SELECT [Geography].[Geo].[Switzerland] ON 0 FROM ( SELECT [Product].[Prod].[Personal] ON 0 FROM [Sales] ))
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Embedded Sub-SubQueries - Same hierarchy

</div>

<div class="ic3-mdx-example-body" style="display:none">

Chained subQueries can be used to filter on the same hierarchy, offering more flexibility than subQueries on multiple axis.

In our example, the first filter applied to all [Europe] countries returns [Spain]. The second filter, [Switzerland], returns an empty set as [Spain] is not in [Switzerland].

**Query**

```
SELECT
    crossjoin([Geography].[Geo].[Europe].children,[Product].[Prod].[icCube].children) ON 0
FROM
    ( SELECT [Geography].[Geo].[Switzerland] ON 0 FROM ( SELECT [Geography].[Geo].[Spain] ON 0 FROM [Sales] ))
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
</tr>
</table>



**Assertion : MDX Visual Equals**

```
SELECT {} ON 0 FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubQueries and default members

</div>

<div class="ic3-mdx-example-body" style="display:none">

In case a default member is filtered-out by a sub-query, a new default member is assigned (the first member of the hierarchy in the sub-query).

Within a calculated member, the default member is the non filtered-out one.

**Query**

```
WITH
    MEMBER [Measures].[Default] AS ( [Time].[Calendar].defaultMember, [Measures].[Amount] )
SELECT
    { [Time].[Calendar].defaultMember } ON 0,
    { [Measures].[Default], [Measures].[Amount] } ON 1
FROM
    ( SELECT [Time].[Calendar].[2011] ON 0 FROM [Sales] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">2011</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">Default</td>
 <td>1023</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">Amount</td>
 <td></td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Default] AS ( [Time].[Calendar].defaultMember, [Measures].[Amount] )
SELECT
    { [Time].[Calendar].[2011] } ON 0,
    { [Measures].[Default], [Measures].[Amount] } ON 1
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubQueries calculated members and member filters

</div>

<div class="ic3-mdx-example-body" style="display:none">

In the context of a calculated measure/member, functions (e.g. children, members) are not filtered.

In the following example the children function in the calculated members return all children, ignoring the sub-query filter.

**Query**

```
WITH
    MEMBER [Measures].[Europe Children Count] AS count([Geography].[Geo].[Europe].children)
SELECT
    { [Measures].[Europe Children Count] } ON 0
FROM
    ( SELECT ([Geography].[Geo].[Switzerland]) ON 0 FROM [Sales] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Europe Children Count</td>
</tr>
<tr>
 <td>3</td>
</tr>
</table>



**Assertion : MDX Visual Equals**

```
WITH
    MEMBER [Measures].[Europe Children Count] AS count([Geography].[Geo].[Europe].children)
SELECT
    { [Measures].[Europe Children Count] } ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubQueries calculated members and facts

</div>

<div class="ic3-mdx-example-body" style="display:none">

If visual mode is active, the result of a tuple evaluation is a visual aggregation. However, in the context of a calculated measure/member if a hierarchy is overwritten the result is the actual aggregation on this hierarchy.

As an example, defining in a calculated measure a tuple as ([Geography].[Geo].[Europe],[Amount]) will return the actual value for [Europe] instead of the visual one.

**Query**

```
WITH
    MEMBER [Measures].[Amount Lausanne] AS [Measures].[Amount]
    MEMBER [Measures].[Amount Lausanne * 2] AS 1 + [Measures].[Amount] * 2
    MEMBER [Measures].[Non Visual Amount] AS ( [Geography].[Geo].currentMember,[Measures].[Amount])
SELECT
    { [Geography].[Geo].[Europe],[Geography].[Geo].[Switzerland] } ON 0,
    { [Measures].[Amount Lausanne],[Measures].[Amount Lausanne * 2], [Measures].[Non Visual Amount] } ON 1
FROM
    ( SELECT ([Geography].[Geo].[Lausanne]) ON 0 FROM [Sales] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Europe</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">Amount Lausanne</td>
 <td>56</td>
 <td>56</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">Amount Lausanne * 2</td>
 <td>113</td>
 <td>113</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">Non Visual Amount</td>
 <td>255</td>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Amount Lausanne] AS ([Measures].[Amount],[Geography].[Geo].[Lausanne])
    MEMBER [Measures].[Amount Lausanne * 2] AS 1+ ([Measures].[Amount],[Geography].[Geo].[Lausanne]) * 2
    MEMBER [Measures].[Non Visual Amount] AS [Measures].[Amount]
SELECT
    { [Geography].[Geo].[Europe],[Geography].[Geo].[Switzerland] } ON 0,
    { [Measures].[Amount Lausanne],[Measures].[Amount Lausanne * 2], [Measures].[Non Visual Amount] } ON 1
FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NON VISUAL flag mode is active

</div>

<div class="ic3-mdx-example-body" style="display:none">

If visual mode is off, values are not anymore a visual aggregation but the 'actual' aggregation as in a classical MDX query (without sub-select).

Therefore subQueries will filter only available members without changing their aggregate values.

**Query**

```
SELECT
    { [Geography].[Geo].[Europe] + [Geography].[Geo].[Switzerland].children } ON 0
FROM
    NON VISUAL ( SELECT ([Geography].[Geo].[Lausanne]) ON 0 FROM [Sales] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Europe</td>
  <td class="ic3-mdx-result-cell-header">Lausanne</td>
</tr>
<tr>
 <td>255</td>
 <td>56</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    { [Geography].[Geo].[Europe],[Geography].[Geo].[Lausanne] } ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Subqueries and measure groups - sharing dimension

</div>

<div class="ic3-mdx-example-body" style="display:none">

Subqueries work also on dimensions that are defined in across measure groups.

In our example, the subselect is defined in dimension [Time] which belongs to both [Amount] and [Fx] measure groups.

**Query**

```
WITH
    MEMBER amountUSD AS [Measures].[Amount] * 1.0
    MEMBER amountEUR AS [Measures].[Amount] * ([Currency].[European Union Currency], [Measures].[FX])
SELECT
    {amountUSD} + {amountEUR}  on 0,
    {[Time].[Calendar].[2010], [Time].[Calendar].[Q2 2010], [Time].[Calendar].[Month].[May 2010]} on 1
  FROM
    ( SELECT [Time].[Calendar].[May 2010] on 0 FROM [SALES] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">amountUSD</td>
  <td class="ic3-mdx-result-cell-header">amountEUR</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">2010</td>
 <td>1023.0</td>
 <td>1106.886</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Q2 2010</td>
 <td>1023.0</td>
 <td>1106.886</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;May 2010</td>
 <td>1023.0</td>
 <td>1106.886</td>
</tr>
</table>



**Assertion : MDX Visual Equals**

```
WITH
    MEMBER [Product].[Prod].[2010]     AS ([Time].[Calendar].[May 2010],[Product].[Prod].defaultMember)
    MEMBER [Product].[Prod].[Q2 2010]  AS ([Time].[Calendar].[May 2010],[Product].[Prod].defaultMember)
    MEMBER [Product].[Prod].[May 2010] AS ([Time].[Calendar].[May 2010],[Product].[Prod].defaultMember)
    MEMBER amountUSD AS [Measures].[Amount] * 1.0
    MEMBER amountEUR AS [Measures].[Amount] * ([Currency].[European Union Currency], [Measures].[FX])
SELECT
    {amountUSD} + {amountEUR}  on 0,
    {[Product].[Prod].[2010],[Product].[Prod].[Q2 2010],[Product].[Prod].[May 2010]} on 1
  FROM [SALES]
  WHERE ([Time].[Calendar].[May 2010])
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Subqueries and measure groups - not sharing dimension

</div>

<div class="ic3-mdx-example-body" style="display:none">

Subqueries work also on a dimension that is defined for a single measure group.

In our example, the subselect is defined in dimension [Geography] which belongs only to [Amount]. Note how
a subquery is working in a similar way as a VisualTotal.

**Query**

```
WITH
    MEMBER amountUSD AS [Measures].[Amount] * 1.0
    MEMBER amountEUR AS [Measures].[Amount] * ([Currency].[European Union Currency], [Measures].[FX])
SELECT
    {amountUSD} + {amountEUR}  on 0,
    [Geography].[Geo].members  on 1
FROM
    ( SELECT [Geography].[Geo].[Madrid] on 0 FROM [SALES] )
 WHERE [Time].[Month].[May 2010]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">amountUSD</td>
  <td class="ic3-mdx-result-cell-header">amountEUR</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">All Regions</td>
 <td>1.0</td>
 <td>1.082</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
 <td>1.0</td>
 <td>1.082</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>1.0</td>
 <td>1.082</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Madrid</td>
 <td>1.0</td>
 <td>1.082</td>
</tr>
</table>



**Assertion : MDX Visual Equals**

```
WITH
    MEMBER amountUSD AS [Measures].[Amount] * 1.0
    MEMBER amountEUR AS [Measures].[Amount] * ([Currency].[European Union Currency], [Measures].[FX])
SELECT
    {amountUSD} + {amountEUR}  on 0,
  VisualTotals({[Geography].[Geo].[All Regions],[Geography].[Geo].[Europe],[Geography].[Geo].[Spain],[Geography].[Geo].[Madrid]})  on 1
FROM
    [SALES]
 WHERE [Time].[Month].[May 2010]
```


**Assertion : MDX Visual Equals**

```
WITH
    MEMBER amountUSD AS [Measures].[Amount] * 1.0
    MEMBER amountEUR AS [Measures].[Amount] * ([Currency].[European Union Currency], [Measures].[FX])
SELECT
    {amountUSD} + {amountEUR}  on 0,
    [Geography].[Geo].members  on 1
FROM
    ( SELECT ([Geography].[Geo].[Madrid],[Time].[Month].[May 2010]) on 0 FROM [SALES] )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Slice in sub-query : axis/slicer hierarchy usage constraint removed (1)

</div>

<div class="ic3-mdx-example-body" style="display:none">

The [Geography].[Geo] is used both on the axis 0 and in the slicer to create an empty cube.

**Query**

```
SELECT [Geography].[Geo].[All Regions] ON 0
FROM ( SELECT [Geography].[Geo].[Switzerland] ON 0 FROM [Sales] WHERE [Geography].[Geo].[Spain] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT ( [Geography].[Geo].[Switzerland], [Geography].[Economy].[Spain] ) ON 0
FROM [Sales]
```


**Assertion : Cell Equals**

```
SELECT { ( [Geography].[Geo].[Switzerland], [Geography].[Economy].[Spain] ) } ON 0
FROM [Sales]
```


**Assertion : Cell Equals**

```
SELECT {} ON 0
FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Slice in sub-query : axis/slicer hierarchy usage constraint removed (2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

The [Geography].[Geo] is used both on the axis 0 and in the slicer to create an empty cube.

**Query**

```
SELECT [Geography].[Geo].[All Regions] ON 0
FROM NON VISUAL ( SELECT [Geography].[Geo].[Switzerland] ON 0 FROM [Sales] WHERE [Geography].[Geo].[Spain] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT ( [Geography].[Geo].[Switzerland], [Geography].[Economy].[Spain] ) ON 0
FROM [Sales]
```


**Assertion : Cell Equals**

```
SELECT { ( [Geography].[Geo].[Switzerland], [Geography].[Economy].[Spain] ) } ON 0
FROM [Sales]
```


**Assertion : Cell Equals**

```
SELECT {} ON 0
FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Slicer(s) usage

</div>

<div class="ic3-mdx-example-body" style="display:none">

A slicer is used both within the actual sub-select (to select the actual country) and within the outer select (to select the period) itself.

**Query**

```
WITH MEMBER [Measures].[x] AS [Time].[Calendar].currentMember.NAME
SELECT { [Measures].[x], [Measures].[Amount] } ON 0, [Geography].[Geo].[All Regions] ON 1
FROM (SELECT Iif( [Time].[Calendar].currentMember.NAME = '2011', [Geography].[Geo].[Spain], [Geography].[Geo].[France] ) ON 0 FROM [Sales] WHERE [Time].[Calendar].[2011] )
WHERE [Time].[Calendar].[May 2010]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">x</td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">All Regions</td>
 <td>May 2010</td>
 <td>3</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH MEMBER [Measures].[x] AS [Time].[Calendar].[May 2010].NAME
     MEMBER [Measures].[y] AS ( [Time].[Calendar].[May 2010], [Geography].[Geo].[Spain], [Measures].[Amount] )

SELECT { [Measures].[x], [Measures].[y] } ON 0, [Geography].[Geo].[All Regions] ON 1
FROM [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Empty slicer

</div>

<div class="ic3-mdx-example-body" style="display:none">

An empty slicer within the sub-select is generating an error.

**Query**

```
SELECT [Geography].[Geo].members ON 0
FROM (SELECT { [Geography].[Geo].[Spain], [Geography].[Geo].[France] } ON 0 FROM [Sales] WHERE [Geography].[Geo].[All].Parent )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_SLICER_NULL_EVAL](icCubeError.md#olap_slicer_null_eval)</td></tr><tr><td>Error Message</td><td>

the slicer cannot be evaluated to a NULL member or an empty set.</td></tr></table>


 
</div>

                                                                         

### See Also


[FilterBy](FilterBy.md)

[Where Clause](Where%20Clause.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
