## SubCubeComplement

Filters the facts performing a complement operation.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |



### Return

```
void
```



### Description

The SubCube functions allows for filtering facts using different operations. They can be used in the Eval() function, in the FILTERBY clause and to create categories.

SubCubeComplement selects all facts not defined by the first parameter. For example SubCubeMinus(A) will define a subCube with the rows not defined by A. Like [All] - [A].

Use this function for large dimensions as using the complement function might improve performance significantly.



### Since Version

4.7


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubCubeComplement()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Creates a subCube using the Complement operator.

In our example, everything except [France].

**Query**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[All but France] AS SubCubeComplement( [Geography].[Geo].[France] )
SELECT
 [Stats].[Ex].[All-M].[All but France] on 0
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">All but France</td>
</tr>
<tr>
 <td>1019</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[All but France] AS ([Measures].[Amount],[Geography].[Geo].[All])-  ([Measures].[Amount],[Geography].[Geo].[France])
SELECT
 [Measures].[All but France] on 0
FROM [Sales]
```


**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[All but France] AS Sum([Geography].[Geo].[Country]-[Geography].[Geo].[France], [Measures].[Amount])
SELECT
 [Measures].[All but France] on 0
FROM [Sales]
```


 
</div>

                                                                                                            

### See Also


[SubCubeIntersect](SubCubeIntersect.md)

[SubCubeMinus](SubCubeMinus.md)

[SubCubeOthers](SubCubeOthers.md)

[SubCubeSymDifference](SubCubeSymDifference.md)

[SubCubeUnion](SubCubeUnion.md)

[FilterBy](FilterBy.md)

[Create (Category)](Create%20(Category).md)

[Eval](Eval.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
