## StripCalculatedMembers

Returns a set generated by filtering out calculated members from the original set.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |



### Return

```
set
```



### Description

Returns a set generated by filtering out calculated members from the original set.

If applied to a tuple set, all tuples with at least one calculated member are filtered out.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StripCalculatedMembers(member-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all members filtering out calculated members.

In our example, the set {[Measures].[V], [Measures].[Amount]} is transformed into {[Measures].[Amount]}

**Query**

```
WITH
    MEMBER [Measures].[V] AS FALSE
SELECT
    StripCalculatedMembers({[Measures].[V], [Measures].[Amount]}) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
 <td>1023</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    [Measures].[Amount] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StripCalculatedMembers(tuple-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

StripCalculatedMembers can be applied to a set of tuples. All tuples with at least one calculated members are filter out of the new set.

**Query**

```
WITH
    MEMBER [Measures].[V] AS FALSE
SELECT
    StripCalculatedMembers(
    {
        ([Geography].[Geo].[Spain], [Measures].[V]),
        ([Geography].[Geo].[Spain], [Measures].[Amount])
    }) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
 <td>3</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    ( [Geography].[Geo].[Spain], [Measures].[Amount] ) ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StripCalculatedMembers(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Function cannot be applied to the string parameter.

**Query**

```
StripCalculatedMembers("hello")
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

StripCalculatedMembers() : argument (0) type mismatch: expected:'set', got:'string'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StripCalculatedMembers(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if applied to a NULL entity.

**Query**

```
StripCalculatedMembers( NULL )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

                                                                         

### See Also


[AddCalculatedMembers](AddCalculatedMembers.md)

[Calculated Members](Calculated%20Members.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
