## StrToMember

Converts a string to a member representation.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |string-expression |one | |
| |CONSTRAINED |zero-one | |



### Return

```
member
```



### Description

Converts a string to its member representation.

- without the CONSTRAINED flag, the string can contain any valid MDX expression that can be converted into a MDX member.

- with the CONSTRAINED flag, only MDX member's name can be used. This allows to avoid code injection into the server.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToMember(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a member after evaluating the string expression.

In our example, we converts "[Geography].[Geo].[Paris]" to a member.

**Query**

```
StrToMember('[Geography].[Geo].[Paris]')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Paris]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
[Geography].[Geo].[Paris]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToMember(string) - MDX expression

</div>

<div class="ic3-mdx-example-body" style="display:none">

The parameter string can be any valid expression containing MDX functions.

In our example, we converts "[Geography].[Geo].[France].children(0)" to a member.

**Query**

```
StrToMember('[Geography].[Geo].[France].children(0)')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Paris]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
[Geography].[Geo].[Paris]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToMember(string,CONSTRAINED)

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the CONSTRAINED flag is present, the string has to match an existing member's name; no evaluation is performed.

**Query**

```
StrToMember( '[Geography].[Geo].[New York]', CONSTRAINED)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[New York]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
[Geography].[Geo].[New York]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToMember(string,CONSTRAINED) - failing

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using functions is not authorized with the CONSTRAINED flag.

**Query**

```
StrToMember( '[Geography].[Geo]', CONSTRAINED)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_CONSTRAINED_VIOLATED](icCubeError.md#olap_constrained_violated)</td></tr><tr><td>Error Message</td><td>

StrToMember() : the restrictions imposed by the CONSTRAINED flag were violated.</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToMember(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if applied to a NULL entity.

**Query**

```
WITH
    MEMBER [Measures].[V] AS StrToMember(NULL)
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">V</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_MDX_EXPRESSION_EXPECTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_MDX_EXPRESSION_EXPECTED](icCubeError.md#olap_mdx_expression_expected)<br>Error Message : StrToMember() : expression expected : received a null/empty string expression.</pre>


 
</div>

                                                                         

### See Also


[LookupByKey](LookupByKey.md)

[LookupByName](LookupByName.md)

[MemberToStr](MemberToStr.md)

[StrToLevel](StrToLevel.md)

[StrToSet](StrToSet.md)

[StrToTuple](StrToTuple.md)

[StrToValue](StrToValue.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
