## StrToHierarchy

Converts a string to a hierarchy representation.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |string-expression |one | |
| |CONSTRAINED |zero-one | |



### Return

```
level
```



### Description

Converts a string to its hierarchy representation.

- without the CONSTRAINED flag, the string can contain any valid MDX expression that can be converted into a MDX hierarchy.

- with the CONSTRAINED flag, only MDX hierarchy's name can be used. This allows to avoid code injection into the server.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToHierarchy(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a hierarchy after evaluating the string expression.

In our example, we converts "[Geography].[Geo]" to a hierarchy.

**Query**

```
StrToHierarchy('[Geography].[Geo]')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[All Regions]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
[Geography].[Geo]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToHierarchy(string,CONSTRAINED)

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the CONSTRAINED flag is present, the string has to match an existing hierarchy's name; no MDX evaluation is performed.

**Query**

```
StrToHierarchy( '[Geography].[Geo]', CONSTRAINED)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[All Regions]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
[Geography].[Geo]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToHierarchy(string,CONSTRAINED) - failing

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using functions is not authorized with the CONSTRAINED flag.

**Query**

```
StrToHierarchy( '[Geography].[Geo].Levels(0)', CONSTRAINED)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_CONSTRAINED_VIOLATED](icCubeError.md#olap_constrained_violated)</td></tr><tr><td>Error Message</td><td>

StrToHierarchy() : the restrictions imposed by the CONSTRAINED flag were violated.</td></tr></table>


 
</div>

                                                                         

### See Also


[StrToMember](StrToMember.md)

[StrToSet](StrToSet.md)

[StrToTuple](StrToTuple.md)

[StrToValue](StrToValue.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
