## StddevP

Returns the standard deviation, dividing by n


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |numeric-expression |one | |



### Return

```
numeric-value
```



### Description

Same as StdevP, returns the standard deviation dividing by n ([Wikipedia](https://en.wikipedia.org/wiki/Standard_deviation)).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StddevP

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the standard deviation. Note that empty members are ignored.

**Query**

```
StddevP( [Geography].[Geo].[Country].members, [Amount] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>312.13809043434605</td></tr></table>


**Assertion : MDX Equals**

```
StdevP( [Geography].[Geo].[Country],[Amount] )
```


**Assertion : MDX Equals**

```
StddevP( nonempty([Geography].[Geo].[Country],[Amount]), [Amount] )
```


 
</div>

                                                                                                            

### See Also


[Stdev](Stdev.md)

[StdevP](StdevP.md)

[Stddev](Stddev.md)

[Var](Var.md)

[VarP](VarP.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
