## Slicer

Returns the set of tuples of the slicer.



### Return

```
set
```



### Description

Returns the set of tuples of the slicer (an empty set if there is no slicer).



### Since Version

5.1.1


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Calculated Member

</div>

<div class="ic3-mdx-example-body" style="display:none">

In our example, we're displaying the name of the member in the slicer.

**Query**

```
with
    member [Measures].[Slicer] as Generate( slicer() as yy, yy.currentMember(0).name, " - " )

select

    { [Measures].[Slicer], [Measures].[Amount] } on 0,
    [Geography].[Geo].[Country].members on 1

    from [Sales]

            where { [Time].[Calendar].[2010], [Time].[Calendar].[2011] }
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Slicer</td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td>2010 - 2011</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td>2010 - 2011</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>2010 - 2011</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Venezuela</td>
 <td>2010 - 2011</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>2010 - 2011</td>
 <td>4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>2010 - 2011</td>
 <td>3</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>2010 - 2011</td>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
with
    member [Measures].[Slicer] as "2010 - 2011"

select

    { [Measures].[Slicer], [Measures].[Amount] } on 0,
    [Geography].[Geo].[Country].members on 1

    from [Sales]

    where { [Time].[Calendar].[2010], [Time].[Calendar].[2011] }
```


 
</div>

                                                                                                            

### See Also


[Axis](Axis.md)

[GetFilterInfo](GetFilterInfo.md)

[SubSelectAxis](SubSelectAxis.md)

[ContextMember](ContextMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
