## SetToStr

Returns a string with the members of the set concatenated using their unique name.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |



### Return

```
string
```



### Description

Returns a string with the members of the set concatenated using their unique name.

The set { [Geography].[Geo].[France], [Geography].[Geo].[United States] } is transformed into this string :

"{[Geography].[Geo].[Country].&[FR],[Geography].[Geo].[Country].&[US]}"

Note there is no guarantee how the unique name is going to be generated (e.g. using keys). You can use Generate function to have a better control on how exactly the resulting string should be.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SetToStr(member-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a string with the members of the set concatenated using their unique name.

**Query**

```
WITH
    MEMBER [Measures].[V] AS SetToStr( { [Geography].[Geo].[France], [Geography].[Geo].[United States] } )
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">V</td>
</tr>
<tr>
 <td>{[Geography].[Geo].[Country].&[FR],[Geography].[Geo].[Country].&[US]}</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[V] AS "{"+[Geography].[Geo].[France].UNIQUE_NAME + "," + [Geography].[Geo].[United States].UNIQUE_NAME + "}"
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SetToStr(member) - implicit conversion example

</div>

<div class="ic3-mdx-example-body" style="display:none">

The member is implicitly converted to a tuple and then to a set containing a single tuple.

**Query**

```
WITH
    MEMBER [Measures].[V] AS SetToStr( [Geography].[Geo].[Switzerland] )
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">V</td>
</tr>
<tr>
 <td>{[Geography].[Geo].[Country].&[CH]}</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[V] AS "{" + [Geography].[Geo].[Switzerland].UNIQUE_NAME +"}"
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SetToStr({}),SetToStr(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns "{}" if applied to NULL entity or an empty set.

**Query**

```
WITH
    MEMBER [Measures].[V] AS SetToStr( {} )
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">V</td>
</tr>
<tr>
 <td>{}</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[V] AS SetToStr(NULL)
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[V] AS "{}"
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SetToStr(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Function couldn't be applied to the string parameters.

**Query**

```
WITH
    MEMBER [Measures].[XXX] AS SetToStr("hello")
SELECT
    [Measures].[XXX] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">XXX</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : SetToStr() : argument (0) type mismatch: expected:'set', got:'string'</pre>


 
</div>

                                                                         

### See Also


[StrToSet](StrToSet.md)

[Generate](Generate.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
