## Root

Returns a tuple containing the ALL members of the specified hierarchies. If ALL member does not exist the default member is used.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |dimension-hierarchy-tuple-expression |zero-one | |



### Return

```
tuple
```



### Description

Returns a tuple containing the ALL members of the specified hierarchies. If ALL member does not exist the default member is used.

1) Root() returns a tuple for all hierarchies (including Measure).
2) Root(Dimension) returns a tuple with hierarchies of the specified dimension.
3) Root(Hierarchy) returns a tuple with hierarchies of the specified hierarchy dimension.
4) Root(Tuple) return a tuple completed with all missing hierarchies of the specified tuple hierarchies.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Root()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a tuple with the ALL or the default member for all hierarchies of the cube.

**Query**

```
Root()
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[All Regions], [Geography].[Economy].[ALL], [Geography].[Letter].[All Letters], [Product].[Prod].[Company].[Crazy Development], [Time].[Calendar].[Year].[2010], [Currency].[Currency].[World], [Stats].[Stats-Dim].[L-Stats-Dim].&[Value], [Stats].[Stats-MA].[L-Stats-MA].&[Value], [Stats].[Stats-Time].[L-Stats-Time].&[Value], [Calendar].[Calendar].[All-M], [Measures].[Amount] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{(
    [Geography].[Geo].DefaultMember,
    [Geography].[Economy].DefaultMember,
    [Geography].[Letter].DefaultMember,
    [Product].[Prod].DefaultMember,
    [Time].[Calendar].DefaultMember,
    [Currency].[Currency].DefaultMember,
    [Stats].[Stats-Dim].DefaultMember,
    [Stats].[Stats-MA].DefaultMember,
    [Stats].[Stats-Time].DefaultMember,
    [Calendar].[Calendar].DefaultMember,
    [Measures].DefaultMember
)}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Root(dimension)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a tuple with the ALL or the default member for all hierarchies of the specified dimension.

**Query**

```
Root( [Geography] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[All Regions], [Geography].[Economy].[ALL], [Geography].[Letter].[All Letters] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{([Geography].[Geo].defaultMember,[Geography].[Economy].defaultMember,[Geography].[Letter].defaultMember)}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Root(hierarchy)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a tuple with the ALL or the default member for all hierarchies of the specified hierarchy's dimension.

**Query**

```
Root( [Geography].[Geo] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[All Regions], [Geography].[Economy].[ALL], [Geography].[Letter].[All Letters] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{([Geography].[Geo].defaultMember,[Geography].[Economy].defaultMember,[Geography].[Letter].defaultMember)}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Root(tuple)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a tuple completed with the with the ALL or the default member of the missing hierarchies.

In our example, the tuple ([Geography].[Geo].[Europe],[Product].[icCube].[Personal]) is completed with [Geography].[Economy].defaultMember and [Geography].[Letter].defaultMember.

**Query**

```
Root( ([Geography].[Geo].[Europe],[Product].[icCube].[Personal]) )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Continent].[Europe], [Geography].[Economy].[ALL], [Geography].[Letter].[All Letters], [Product].[Prod].[Licence].[Personal] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{([Geography].[Geo].[Europe],[Geography].[Economy].defaultMember,[Geography].[Letter].defaultMember,[Product].[icCube].[Personal])}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Root(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a tuple completed with the missing hierarchies.

In our example, the member [Geography].[Geo].[Europe] is completed with [Geography].[Economy].defaultMember and [Geography].[Letter].defaultMember.

**Query**

```
Root( [Geography].[Geo].[Europe] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Continent].[Europe], [Geography].[Economy].[ALL], [Geography].[Letter].[All Letters] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{([Geography].[Geo].[Europe],[Geography].[Economy].defaultMember,[Geography].[Letter].defaultMember)}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Root(memberSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Root( {[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Root() : argument (0) type mismatch: expected:'tuple|hierarchy|dimension', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Root(tupleSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Root( {([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Root() : argument (0) type mismatch: expected:'tuple|hierarchy|dimension', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Root(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if applied with a NULL argument.

**Query**

```
Root(NULL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

                                                                         

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
