## Replicate

Returns a set replicating n times the member or set parameter.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|member|set |member-expression |one | |
|times |value-expression |one | |



### Return

```
set
```



### Description

The function returns a set that is a 'times' replica of the first parameter that can
be a set or a member expression.

[Geography].[Geo].[ALL].Times(2) will return {[Geography].[Geo].[ALL], [Geography].[Geo].[ALL]}

Times( {[Geography].[Geo].[ALL], [Geography].[Geo].[ALL]}, 2) will return 4 times the member [ALL].

This function can be used with currentOrdinal to simulate a for loop.



### Since Version

6.0


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Replicate(member,2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a set with two copies the ALL member.

**Query**

```
Replicate([Geography].[Geo].[All Regions],2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[All Regions], 
  [Geography].[Geo].[All Regions]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[All Regions],[Geography].[Geo].[All Regions]}
```


**Assertion : MDX Equals**

```
[Geography].[Geo].[All Regions].Replicate(2)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Replicate(set,2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a set with four copies the [America] member.

**Query**

```
Replicate({[Geography].[Geo].[America],[Geography].[Geo].[America]},2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Continent].[America]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[America],[Geography].[Geo].[America],[Geography].[Geo].[America],[Geography].[Geo].[America]}
```


**Assertion : MDX Equals**

```
{[Geography].[Geo].[America],[Geography].[Geo].[America]}.Replicate(2)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Vector( Replicate(member,10) as t, t.currentOrdinal )

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example of usage that simulates a for loop using Replicate and CurrentOrdinal

**Query**

```
Vector( Replicate([Geography].[Geo].[America],5) as t, t.currentOrdinal /* like the i of a for (i) loop */ )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>[1.0, 2.0, 3.0, 4.0, 5.0]</td></tr></table>


**Assertion : MDX Equals**

```
VectorN(1,2,3,4,5)
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Replicate(NULL,2) | Replicate(member,0) 

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns null if the parameter is an empty set or null or the value is equal or less than zero.

**Query**

```
Replicate(NULL,2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Replicate([Geography].[Geo].[America],0)
```


**Assertion : MDX Equals**

```
Replicate([Geography].[Geo].[America],-1)
```


 
</div>

                                                                         

### See Also


[Generate](Generate.md)

[Vector](Vector.md)

[CurrentOrdinal](CurrentOrdinal.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
