## Rank

Returns the rank (one-based position) of the tuple in the specified set (0 if not found).


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |tuple-expression |one | |
| |set-expression |one | |
| |numeric-expression |zero-one | |



### Return

```
numeric-value
```



### Description

Returns the rank of the specified tuple in the set. If the tuple is not found 0 is returned.

If an numeric-expression is specified, the set is sorted in a descending order using this numeric-expression. Tuples with the same expression value have the same rank value.

The tuple set { A, B, C, D } with the respective numeric-expression values of { 2,1,2,4 } will be ranked as { B(rank=4), A(rank=2), C(rank=2), D(rank=1) }

This function is similar to: Rank( tuple, Order( tuple-set, numeric-expression, DESC) ). Note this MDX expression does not handle tuple with same value correctly.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Rank(tuple,tuple-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the one-based position of the tuple in the tuple set.

**Query**

```
WITH
    MEMBER [Measures].[First rank] AS  Rank(([Geography].[Geo].[Zurich],[Time].[Calendar].[2010] ),{([Geography].[Geo].[Zurich],[Time].[Calendar].[2010]),([Geography].[Geo].[Madrid],[Time].[Calendar].[2010])})
    MEMBER [Measures].[Second rank] AS  Rank(([Geography].[Geo].[Madrid],[Time].[Calendar].[2010] ),{([Geography].[Geo].[Zurich],[Time].[Calendar].[2010]),([Geography].[Geo].[Madrid],[Time].[Calendar].[2010])})
SELECT
    {[Measures].[First rank],[Measures].[Second rank]}  ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">First rank</td>
  <td class="ic3-mdx-result-cell-header">Second rank</td>
</tr>
<tr>
 <td>1</td>
 <td>2</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[First rank] AS 1
    MEMBER [Measures].[Second rank] AS 2
SELECT
    {[Measures].[First rank],[Measures].[Second rank]}  ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Rank(tuple,tuple-set,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the one-based position of the tuple in the specified set, sorted using the numeric expression.

In our example, the set {[Zurich],[Geneva]} is ordered as {[Geneva], [Zurich]}. Rank for [Geneva] is 1 and for [Zurich] 2.

**Query**

```
WITH
    MEMBER [Measures].[A] AS CASE [Geography].[Geo].CurrentMember.Properties( 'Name' )
                                WHEN 'Geneva' THEN 10
                                WHEN 'Zurich' THEN 3
                                ELSE 0
                             END

    MEMBER [Measures].[Zurich rank]  AS Rank([Geography].[Geo].[Zurich], {[Geography].[Geo].[Zurich],[Geography].[Geo].[Geneva]},[Measures].[A])
    MEMBER [Measures].[Geneva rank] AS Rank([Geography].[Geo].[Geneva], {[Geography].[Geo].[Zurich],[Geography].[Geo].[Geneva]},[Measures].[A])

SELECT
    {[Measures].[Zurich rank],[Measures].[Geneva rank]}  ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Zurich rank</td>
  <td class="ic3-mdx-result-cell-header">Geneva rank</td>
</tr>
<tr>
 <td>2</td>
 <td>1</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Zurich rank] AS 2
    MEMBER [Measures].[Geneva rank] AS 1
SELECT
    {[Measures].[Zurich rank],[Measures].[Geneva rank]}  ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Rank(tuple,tuple-set) - duplicated tuples

</div>

<div class="ic3-mdx-example-body" style="display:none">

Duplicated members are not removed. For the set { [Zurich], [Zurich], [Madrid] } :

- For [Zurich] rank, 1 is returned as it is the first element,
- For [Madrid] rank, 3 is returned as both [Zurich] members are counted.

**Query**

```
WITH
    MEMBER [Measures].[1] AS  Rank([Geography].[Geo].[Zurich],{[Geography].[Geo].[Zurich],[Geography].[Geo].[Zurich],[Geography].[Geo].[Madrid]})
    MEMBER [Measures].[3] AS  Rank([Geography].[Geo].[Madrid],{[Geography].[Geo].[Zurich],[Geography].[Geo].[Zurich],[Geography].[Geo].[Madrid]})
SELECT
    {[Measures].[1],[Measures].[3]}  ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">1</td>
  <td class="ic3-mdx-result-cell-header">3</td>
</tr>
<tr>
 <td>1</td>
 <td>3</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[1] AS 1
    MEMBER [Measures].[3] AS 3
SELECT
    {[Measures].[1],[Measures].[3]}  ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Rank(tuple,tuple-set,numeric) - same value

</div>

<div class="ic3-mdx-example-body" style="display:none">

Members with same value share the same ranking. For the set { [Zurich], [Geneva], [Madrid] } :

- For [Madrid] rank, is 1 as it has the biggest value.
- For [Geneva] rank, is also 1 at it has the same value as [Madrid].
- For [Zurich] rank, is 3 as it is the last member of the ordered list.

**Query**

```
WITH
    MEMBER [Measures].[A] AS CASE [Geography].[Geo].CurrentMember.Properties( 'Name' )
                                WHEN 'Madrid' THEN 10
                                WHEN 'Geneva' THEN 10
                                WHEN 'Zurich' THEN 1
                                ELSE 0
                             END
    MEMBER [Measures].[Madrid] AS  Rank([Geography].[Geo].[Madrid],{[Geography].[Geo].[Zurich],[Geography].[Geo].[Geneva],[Geography].[Geo].[Madrid]},[Measures].[A])
    MEMBER [Measures].[Geneva] AS  Rank([Geography].[Geo].[Geneva],{[Geography].[Geo].[Zurich],[Geography].[Geo].[Geneva],[Geography].[Geo].[Madrid]},[Measures].[A])
    MEMBER [Measures].[Zurich] AS  Rank([Geography].[Geo].[Zurich],{[Geography].[Geo].[Zurich],[Geography].[Geo].[Geneva],[Geography].[Geo].[Madrid]},[Measures].[A])
SELECT
    {[Measures].[Madrid],[Measures].[Geneva],[Measures].[Zurich]}  ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Geneva</td>
  <td class="ic3-mdx-result-cell-header">Zurich</td>
</tr>
<tr>
 <td>1</td>
 <td>1</td>
 <td>3</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[1] AS 1
    MEMBER [Measures].[3] AS 3
SELECT
    {[Measures].[1],[Measures].[1],[Measures].[3]}  ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Rank(tuple,tuple-set) - missing tuple

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns 0 if the member or tuple is not present in the set.

**Query**

```
WITH
    MEMBER [Measures].[1] AS  Rank(([Geography].[Geo].[New York]),{([Geography].[Geo].[Zurich]),([Geography].[Geo].[Zurich]),([Geography].[Geo].[Madrid]),([Geography].[Geo].[Geneva])})
SELECT
    {[Measures].[1]}  ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">1</td>
</tr>
<tr>
 <td>0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[1] AS 0
SELECT
    {[Measures].[1]}  ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[1] AS  Rank(NULL,{([Geography].[Geo].[Zurich]),([Geography].[Geo].[Zurich]),([Geography].[Geo].[Madrid]),([Geography].[Geo].[Geneva])})
SELECT
    {[Measures].[1]}  ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Rank(tuple,{})

</div>

<div class="ic3-mdx-example-body" style="display:none">

Ranking a tuple using an empty set generates an error.

**Query**

```
Rank( ([Geography].[Geo].[Zurich],[Time].[Calendar].[2010] ), {} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Rank() : argument (1) type mismatch: expected:'non-empty-set', got:'{}'</td></tr></table>


 
</div>

                                                                         

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
