## Range

Returns the set that is a subset of parameter set, starting at the second member's parameter till the third one.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |tuple-expression |one | |
| |tuple-expression |one | |



### Return

```
set
```



### Description

If the parameters are defined as set1, tuple1 and tuple2 :

if both tuples are defined, a subset of set1 starting at tuple1 and ending at tuple2 (both included)
if tuple1 is null, a subset of set1 ending at tuple2 (included)
if tuple2 is null, a subset of set1 starting at tuple1 till the end.
if both tuple are null, set1.

This is similar to the Range operator in MDX, :.



### Since Version

6.8.6


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Range(set,null,tuple2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first set till tuple2.

**Query**

```
Range( {[Geography].[Geo].[Canada], [Geography].[Geo].[America], [Geography].[Geo].[Switzerland], [Geography].[Geo].[France]}, null , [Geography].[Geo].[America])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[Continent].[America]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Canada], [Geography].[Geo].[America]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Range(set,tuple1,null)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first set starting at tuple1 till the end

**Query**

```
Range( {[Geography].[Geo].[Canada], [Geography].[Geo].[America], [Geography].[Geo].[Switzerland], [Geography].[Geo].[France]}, [Geography].[Geo].[America], null)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Country].[Switzerland], 
  [Geography].[Geo].[Country].[France]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[America], [Geography].[Geo].[Switzerland], [Geography].[Geo].[France]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Range(set,tuple1,tuple2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Return the set starting at tuple1 and ending at tuple2 (both included)

**Query**

```
Range( {[Geography].[Geo].[Canada], [Geography].[Geo].[America], [Geography].[Geo].[Switzerland], [Geography].[Geo].[France]}, [Geography].[Geo].[America], [Geography].[Geo].[Switzerland])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Country].[Switzerland]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[America], [Geography].[Geo].[Switzerland]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Range(set,notFoundMember,null)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if the first tuple1 is defined but not found in the set.

**Query**

```
Range( {[Geography].[Geo].[Canada], [Geography].[Geo].[America], [Geography].[Geo].[Switzerland], [Geography].[Geo].[France]}, [Geography].[Geo].[Spain],null)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Canada], [Geography].[Geo].[America], [Geography].[Geo].[Switzerland], [Geography].[Geo].[France]}.Range( [Geography].[Geo].[Spain], [Geography].[Geo].[America])
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Range(set,tuple1,notFoundMember)

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the second tuple is not found it will return the set starting from tuple1 till the end.

**Query**

```
Range( {[Geography].[Geo].[Canada], [Geography].[Geo].[America], [Geography].[Geo].[Switzerland], [Geography].[Geo].[France]}, [Geography].[Geo].[Switzerland], [Geography].[Geo].[Spain])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Switzerland], 
  [Geography].[Geo].[Country].[France]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Switzerland], [Geography].[Geo].[France]}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Range(set,null,null)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Return the set if both tuples are null

**Query**

```
Range( {[Geography].[Geo].[Canada], [Geography].[Geo].[America], [Geography].[Geo].[Switzerland], [Geography].[Geo].[France]}, null,null)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Country].[Switzerland], 
  [Geography].[Geo].[Country].[France]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Canada], [Geography].[Geo].[America], [Geography].[Geo].[Switzerland], [Geography].[Geo].[France]}
```


 
</div>

                                                                         

### See Also


[Head](Head.md)

[Tail](Tail.md)

[Subset](Subset.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
